#version 330 core

in vec2 fragmentUV;

layout(location=0) out vec4 fragColor;

uniform sampler2D scene;
uniform sampler2D contours;
uniform sampler2D bloom;

uniform bool contoursEnabled;
uniform bool bloomEnabled;

void main()
{
    vec3 sceneColor = texture(scene, fragmentUV).rgb;
    vec3 contoursColor = texture(contours, fragmentUV).rgb;
	vec3 bloomColor = texture(bloom, fragmentUV).rgb;

	// Effect: Contours
    if (contoursEnabled)  {
        sceneColor += contoursColor; // additive blending
	}

	// Effect: Bloom
	if (bloomEnabled) {
		sceneColor += bloomColor; // additive blending
	}

	fragColor = vec4(sceneColor, 1.0);
}