#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out vec3 fragmentPosition;
out vec3 fragNormal;
out vec2 fragmentUV;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
	fragmentUV = uv;
	fragNormal = (model * vec4(normal, 0)).xyz;
	gl_Position = projection* view * model * vec4(position, 1);
	fragmentPosition = gl_Position.rgb;
}