#version 330 core

in vec3 fragmentPosition;
in vec3 fragNormal;
in vec2 fragmentUV;

layout(location=0) out vec4 fragColor;
layout(location=1) out vec4 brightColor;

uniform vec3 diffuseColor;
uniform vec3 specularColor;
uniform int hasTexture;
uniform int hasNormalMap;
uniform int hasLighting;
uniform vec3 cameraPosition;
uniform vec3 lightPosition;
uniform sampler2D color_texture;

uniform bool celShading;
uniform bool colorWireframeModeEnabled;
uniform vec3 colorWireframeMode;

vec3 sub(vec3 v1, vec3 v2);
float dot(vec3 v1, vec3 v2);
vec3 mul(vec3 v, float f);
float max(float x, float y);
vec3 norm(vec3 v);
float length(vec3 v);

float diffuseSimple(vec3 L, vec3 N){
   return clamp(dot(L,N),0.0,1.0);
}

float specularSimple(vec3 L,vec3 N,vec3 H){
   if(dot(N,L)>0){
      return pow(clamp(dot(H,N),0.0,1.0),32.0);
   }
   return 0.0;
}

void main() 
{
	if(colorWireframeModeEnabled) {
		fragColor = vec4(colorWireframeMode, 1.0f);
		brightColor = fragColor;
	}
	else {
		vec3 v = norm(sub(cameraPosition, fragmentPosition));
		vec3 l = norm(sub(lightPosition, fragmentPosition));
		vec3 h = norm(v + l);
		vec3 n = norm(fragNormal);

		vec3 textureColor = texture(color_texture, fragmentUV).rgb;
	
		float ambientIntensity = 0.2f;
		float diffuseIntensity = diffuseSimple(l, n) * 1.2;
		float specularIntensity = specularSimple(l, n, h);

		float intensity = ambientIntensity + diffuseIntensity + specularIntensity;
		float shadeIntensity;

		// Effect: Cel Shading
		if (celShading) { 
			shadeIntensity = ceil(intensity * 10) / 10; 
		} else { 
			shadeIntensity = intensity; 
		} 

		fragColor = vec4(textureColor * shadeIntensity, 1.0); 

		// Effect: Bloom
		float brightness = dot(fragColor.rgb, vec3(0.2126, 0.7152, 0.0722)); // extract the brightness from the color (grayscale)
		if (brightness > 0.9f) {
			brightColor = vec4(fragColor.rgb, 1.0);
		} else {
			brightColor = vec4(0, 0, 0, 1);
		}
	}
}

float max(float x, float y)
{
	return x > y ? x : y;
}

float dot(vec3 v1, vec3 v2)
{
	return v1.r * v2.r + v1.g * v2.g + v1.b * v2.b;
}

vec3 mul(vec3 v, float f)
{
	return vec3(v.r * f, v.g * f, v.b * f);
}

vec3 sub(vec3 v1, vec3 v2)
{
	return vec3(v1.r - v2.r, v1.g - v2.g, v1.b - v2.b); 
}

vec3 norm(vec3 v)
{
	float l = length(v);
	return vec3(v.r / l, v.g / l, v.b / l);
}

float length(vec3 v)
{
	return sqrt(v.r * v.r + v.g * v.g + v.b * v.b);
}
	
/*float cos = max(dot(n, l), 0) * 0.6f + ambientIntensity;

if(hasTexture == 1) {
	vec3 textureColor = texture(color_texture, fragmentUV).rgb;
	fragColor = vec4(textureColor, 1.0);
} else {
	fragColor = vec4((0.8 * diffuseColor * cos) + (1 * specularColor * pow(max(dot(n, h), 0), 50)), 1.0);
}

if(hasLighting == 1) {
	fragColor = fragColor * vec4((0.8 * diffuseColor * cos) + (1 * specularColor * pow(max(dot(n, h), 0), 32)), 1.0);
}*/