#version 330

in vec2 fragmentUV;

layout(location=0) out vec4 fragColor;

uniform sampler2D color_texture;

const float offset = 1.0 / 300.0;  

void main()
{
    vec2 offsets[9] = vec2[](
        vec2(-offset,  offset), // top-left
        vec2( 0.0f,    offset), // top-center
        vec2( offset,  offset), // top-right
        vec2(-offset,  0.0f),   // center-left
        vec2( 0.0f,    0.0f),   // center-center
        vec2( offset,  0.0f),   // center-right
        vec2(-offset, -offset), // bottom-left
        vec2( 0.0f,   -offset), // bottom-center
        vec2( offset, -offset)  // bottom-right    
    );

    float kernelEdgeDetection[9] = float[](
        1, 1, 1,
        1, -8, 1,
        1, 1, 1
    );
	
    float kernelGaussian[9] = float[](
        1, 1, 1,
        1, -8, 1,
        1, 1, 1
    );

    float kernelDilation[9] = float[](
        2, 2, 2,
        2, 2, 2,
        2, 2, 2
    );
    
    vec3 sampleTex[9];
    for(int i = 0; i < 9; i++)
    {
        sampleTex[i] = vec3(texture(color_texture, fragmentUV.st + offsets[i]));
    }
    vec3 col = vec3(0.0);
    for(int i = 0; i < 9; i++) {
        col += sampleTex[i] * kernelEdgeDetection[i] * kernelDilation[i] * kernelDilation[i];
	}
    
    fragColor = vec4(col, 1.0);
	
    float average = 0.2126 * fragColor.r + 0.7152 * fragColor.g + 0.0722 * fragColor.b;
    fragColor = vec4(average, 0, 0, 1.0);
}