#version 330 core

layout(location=0)
in vec3 position;
layout(location=1)
in vec3 normal;
layout(location=2)
in vec2 texture_uv;
layout(location=3)
in vec3 tangent;

out vec3 fragNormal;
out vec3 fragPos;
out vec2 Texture_uv;
out mat3 TBN;
out mat3 TBNI;
out vec4 FragPosLightSpace;

out vec3 TangentLightPos;
out vec3 TangentViewPos;
out vec3 TangentFragPos;

uniform vec3 viewPos;
uniform vec3 lightPos;

uniform mat4 model;
uniform mat4 VP;
uniform mat4 lightSpaceMatrix;

void main() {

	fragNormal = (model * vec4(normal, 0)).xyz;
	gl_Position = VP * model * vec4(position, 1);
	fragPos = vec3(model * vec4(position, 1.0f));
    Texture_uv = texture_uv;

	FragPosLightSpace = lightSpaceMatrix * model * vec4(position, 1);

	vec3 T = normalize(vec3(model * vec4(tangent, 0.0)));
	vec3 N = normalize(vec3(model * vec4(normal, 0.0)));
	vec3 B = cross(T, N);
	TBN = mat3(T, B, N);
	TBNI = transpose(TBN);

	TangentLightPos = TBNI * lightPos;
	TangentViewPos = TBNI * viewPos;
	TangentFragPos = TBNI * fragPos;
}
