#version 330 core

in vec2 TexCoords;

out vec4 FragColor;

uniform sampler2D image;
uniform bool horizontal;

uniform float weight[5] = float[] (0.2270270270, 0.1945945946, 0.1216216216, 0.0540540541, 0.0162162162);

void main()
{
    vec2 tex_offset = 1.0 / textureSize(image, 0); // gets size of single texel
    vec4 result = texture2D(image, TexCoords).rgba * weight[0];

	if(horizontal) {
		for(int i = 1; i < 5; ++i) {
			result += texture2D(image, TexCoords + vec2(tex_offset.x * i, 0.0)).rgba * weight[i];
			result += texture2D(image, TexCoords - vec2(tex_offset.x * i, 0.0)).rgba * weight[i];
		}
	}
	else {
		for(int i = 1; i < 5; ++i) {
			result += texture2D(image, TexCoords + vec2(0.0, tex_offset.y * i)).rgba * weight[i];
			result += texture2D(image, TexCoords - vec2(0.0, tex_offset.y * i)).rgba * weight[i];
		}
	}

	FragColor = vec4(result);
}