#version 330 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 uv;

out VS_OUT {
	vec3 fragment_pos;
	vec3 world_normal;
	vec2 fragment_UV;
	vec4 fragment_pos_lvp;
} vs_out;

uniform mat4 model;
uniform mat4 view_proj;
uniform mat4 light_view_proj;

void main(){

	gl_Position = view_proj * model * vec4(position, 1);
	vs_out.fragment_pos = vec3(model * vec4(position, 1));
	vs_out.world_normal = normalize(transpose(inverse(mat3(model))) * normal);
	vs_out.fragment_UV = uv;
	vs_out.fragment_pos_lvp = light_view_proj * vec4(model * vec4(position, 1));
}