#version 330 core

layout (location = 0) in vec3 position;
out vec3 TexCoords;

//uniform mat4 modelMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;

void main()
{
    // Flipped position because textures will be render flipped otherwise.
    vec4 pos = projectionMatrix * viewMatrix * vec4(-position, 1.0f);
    // By setting z = w the depth will always be 1 in the fragment shader.
    gl_Position = pos.xyww;
    TexCoords = position;
}
