#version 330 core

in vec3 TexCoords;

layout (location = 0) out vec4 fragColor;
layout (location = 1) out vec4 brightColor;

uniform samplerCube skybox;

void main()
{
    fragColor = texture(skybox, TexCoords);

    float brightness = dot(fragColor.rgb, vec3(0.2126, 0.7152, 0.0722));
    if (brightness > 0.99) brightColor = vec4(fragColor.rgb, 1.0);
    else brightColor = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    //brightColor = vec4(0.0f, 0.0f, 0.0f, 1.0f);
}
