#version 330 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoord;
layout (location = 3) in vec3 tangent;
layout (location = 4) in vec3 bitangent;

out vec3 Normal;
out vec3 FragPos;
out vec2 TexCoord;
out vec4 FragPosLightSpace;
out mat3 tangentMatrix;

uniform mat4 modelMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 lightSpaceMatrix;

void main()
{
    gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(position, 1.f);
    //gl_Position = lightSpaceMatrix * modelMatrix * vec4(position, 1.f);
    FragPos = vec3(modelMatrix * vec4(position, 1.f));
    Normal = vec3(mat4(transpose(inverse(modelMatrix))) * vec4(normal, 1.f));
    TexCoord = vec2(texCoord.x, 1 - texCoord.y);
	FragPosLightSpace = lightSpaceMatrix * vec4(FragPos, 1.0);

    // Build tangent matrix for normal mapping
    vec3 n = normalize(vec3(modelMatrix * vec4(normal, 0.0)));
    vec3 t = normalize(vec3(modelMatrix * vec4(tangent, 0.0)));
    vec3 b = normalize(vec3(modelMatrix * vec4(bitangent, 0.0)));
    tangentMatrix = mat3(t, b, n);
}