// http://learnopengl.com/#!Advanced-Lighting/Bloom
#version 330 core

in vec2 TexCoords;
out vec4 FragColor;

uniform sampler2D screenTexture;

// gauss weights
// Kernel size: 9, Sigma: 2
uniform int count = 5;
uniform float weights[5] = float[] (0.20236, 0.179044, 0.124009, 0.067234, 0.028532);

void main()
{
    // Calculate offset with texel size
    vec2 texelSize = 1.0 / textureSize(screenTexture, 0);
    // Add weighted values of the current fragment
    vec3 result = texture(screenTexture, TexCoords).rgb * weights[0];
    vec2 offset;
    //int count = weights.length();
    
    for(int i = 1; i < count; ++i)
    {
        offset = vec2(texelSize.x * i, 0.0);
        result += texture(screenTexture, TexCoords + offset).rgb * weights[i];
        result += texture(screenTexture, TexCoords - offset).rgb * weights[i];
    }
    
    FragColor = vec4(result, 1.0);
}