#version 330

// Input vertex data, different for all executions of this shader.
in vec3 position;
in vec3 normal;
in vec2 vertexUV;
//in vec3 lightPos;

out vec2 UV;
//out vec4 pos;
//out vec3 worldNormal;
//out vec3 normal_cameraspace;
//out vec3 lightDir_cameraspace;

// Values that stay constant for the whole mesh.
uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

void main()
{
	vec3 position_cameraspace = ( viewMatrix * modelMatrix * vec4(position,1)).xyz;
	gl_Position = projectionMatrix * vec4(position_cameraspace,1);
	UV = vertexUV;
}


//#version 330 core
 
// Input vertex data, different for all executions of this shader.
//layout(location = 0) in vec3 vertexPosition_modelspace;
//layout(location = 1) in vec2 vertexUV;
 
// Output data ; will be interpolated for each fragment.
//out vec2 UV;
 
// Values that stay constant for the whole mesh.
//uniform mat4 MVP;
 
//void main(){
 
    // Output position of the vertex, in clip space : MVP * position
    //gl_Position =  MVP * vec4(vertexPosition_modelspace,1);
 
    // UV of the vertex. No special space for this one.
    //UV = vertexUV;
//}