#version 330 core

in vec3 normal_cameraspace;
in vec3 lightDir_cameraspace;
in vec3 normal_worldspacae;

in vec4 smCoords;
//in vec4 pos;

//uniform sampler2Dshadow shadowMap;
uniform sampler2DShadow shadowMap;

//in vec3 lightPosFrag;
out vec4 fragColor;

uniform vec3 colour;

bool check(in float value, in float target)
{
	return (value > target - 0.1) && (value < target + 0.1);
}

bool checkVec(in vec4 value, in vec4 target)
{
	return check(value[0], target[0]) && check(value[1], target[1]) && check(value[2], target[2]) && check(value[3], target[3]);
}

void main()
{
	if(checkVec(smCoords, vec4(-2, -3, -4, -5))){
		fragColor = vec4(colour, 0);
		//fragColor = vec4(0, 1, 0, 0);
	}else{
		float cosTheta;
		float shadowMult;
		if(checkVec(smCoords, vec4(-1, -2, -3, -4))){ // no shadow mapping
			shadowMult = 1; //1..
			vec3 n = normalize( normal_cameraspace );
			vec3 l = normalize( lightDir_cameraspace );
			cosTheta = clamp( dot( n,l ), 0, 1 );
		}else{ // shadow mapping (no point light)
			//vec3 sm_ndc = smCoords.xyz / smCoords.w;
			//float shadowMult = textureProj(shadowMap, smCoords);

			vec3 sm_ndc = smCoords.xyz/ smCoords.w;
			shadowMult = clamp(texture(shadowMap, sm_ndc), 0, 1); //+0.5

			
			cosTheta = 0.5;
		}

		vec3 n = normalize( normal_cameraspace );
		vec3 l = normalize( lightDir_cameraspace );
		cosTheta = clamp( dot( n,l ), 0, 1 );

		fragColor = (vec4(vec3(0.1, 0.1, 0.1)*colour,1)+vec4(colour * cosTheta,1))*shadowMult;
	}
}