#version 330 core

// Input vertex data, different for all executions of this shader.
in vec3 position;
in vec3 normal;
in vec3 lightPos;

out vec3 normal_worldspacae;
out vec3 normal_cameraspace;
out vec3 lightDir_cameraspace;
out vec4 smCoords;
//out vec4 pos;

// Values that stay constant for the whole mesh.

uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;
uniform vec3 colour;

uniform mat4 l_pl_vl_matrix;

bool check(in float value, in float target)
{
	return (value > target - 0.1) && (value < target + 0.1);
}

bool checkVec(in vec4 value, in vec4 target)
{
	return check(value[0], target[0]) && check(value[1], target[1]) && check(value[2], target[2]) && check(value[3], target[3]);
}

void main()
{
	normal_worldspacae = (modelMatrix * vec4(normal, 0)).xyz;
	normal_cameraspace = (viewMatrix * vec4(normal_worldspacae, 0)).xyz;

	vec3 position_cameraspace = ( viewMatrix * modelMatrix * vec4(position,1)).xyz;

	gl_Position = projectionMatrix * vec4(position_cameraspace,1);

	vec3 eyeDir_cameraspace = vec3(0,0,0) - position_cameraspace;

	vec3 lightPos_cameraspace = ( viewMatrix * vec4(vec3(0,0,0),1)).xyz;
	lightDir_cameraspace = lightPos_cameraspace + eyeDir_cameraspace;
 
	if(checkVec(l_pl_vl_matrix[3], vec4(-1, -2, -3, -4))){
		smCoords = vec4(-1, -2, -3, -4);
	}else if(checkVec(l_pl_vl_matrix[3], vec4(-2, -3, -4, -5))){ //glows
		smCoords = vec4(-2, -3, -4, -5);
	}else{
		smCoords = l_pl_vl_matrix * modelMatrix * vec4(position, 1);
	}
}
