#version 330 core
#pragma optionNV (unroll all)

// Shader based on
// http://ogldev.atspace.co.uk/www/tutorial28/tutorial28.html

layout(points) in;                                                                  
layout(points) out;                                                     
layout(max_vertices = 11) out;                                                       
       
in float Type0[];                                                                        
in vec3 Position0[];                                                                
in vec3 Velocity0[];                                                                
in float Age0[];        
            
out float Type1;                                                        
out vec3 Position1;                                                                 
out vec3 Velocity1;                                                                 
out float Age1;                                                                     
                     
uniform vec3 gEmitterPosition;         
uniform vec3 gRandomSpeed;                                                         
uniform float gDeltaTimeMillis;                                                       
uniform float gSimpleParticleLifetime;
uniform float gPlayerSpeed;                                                 
                   
#define EMITTER_PARTICLE 0.0f
#define SIMPLE_PARTICLE 1.0f
				 
// http://byteblacksmith.com/improvements-to-the-canonical-one-liner-glsl-rand-for-opengl-es-2-0/
highp float rand(vec2 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float c = 43758.5453;
    highp float dt= dot(co.xy ,vec2(a,b));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}
				                                                                    
void main() { 	
	float Age = Age0[0] + gDeltaTimeMillis;                                         
                                                                                    
    if (Type0[0] == EMITTER_PARTICLE) {  
		// Emit emitter first, so it will be at index 0 on next iteration.
		Type1 = EMITTER_PARTICLE;                                             
        Position1 = gEmitterPosition;                                            
        Velocity1 = Velocity0[0];                                                   
        Age1 = Age;                                                                 
        EmitVertex();                                                               
        EndPrimitive();         
   
		// Emit particles		         
		for (int i = 0 ; i < 10; i++) {                                    
			Type1 = SIMPLE_PARTICLE;                     
			        
			Position1 = gEmitterPosition;                                  
			Velocity1 = gRandomSpeed;                          
			Age1 = 0.0f;                                                   
			EmitVertex();													
			EndPrimitive();                                                
        }       
		
    }                                                                               
    else {                                                                                                               
        float DeltaTimeSecs = gDeltaTimeMillis / 1000.0f;                                                                             
        vec3 DeltaP = DeltaTimeSecs * Velocity0[0];                                 
        vec3 DeltaV = vec3(DeltaTimeSecs) * (0.0, -9.81, 0.0);                      
                           
		if (Age < gSimpleParticleLifetime) {
			Type1 = SIMPLE_PARTICLE;             	            
			Position1 = Position0[0] + DeltaP;                                  
	        Velocity1 = Velocity0[0] + DeltaV;                                
	        Age1 = Age;                                                         
            EmitVertex();                                                       
            EndPrimitive();    
		}  else{
			Type1 = SIMPLE_PARTICLE;                         
			Position1 = gEmitterPosition;                                  
	        Velocity1 = Velocity0[0];                                
	        Age1 = 0.0f;                                                         
            EmitVertex();                                                       
            EndPrimitive();  
		}                                                                                                 
    }   
	
	            
	
}