#version 330 core

const float motionBlurIterations = 20;
const float blurStrength=1f;

const float sampleDivXZ=512;
const float sampleDivY =16;

in vec2 uv;

uniform sampler2D colorTexture;
uniform sampler2D dataTexture;

uniform vec2 screenDimensions;

uniform float playerSpeedMult;

const int MAX_LIGHTS = 10;
uniform int lightCount;
uniform int lightType[MAX_LIGHTS];
uniform vec3 lightPosition[MAX_LIGHTS];
uniform vec3 lightDirection[MAX_LIGHTS];
uniform vec3 lightIntensity[MAX_LIGHTS];
uniform float lightRange[MAX_LIGHTS];
uniform float lightAngle[MAX_LIGHTS];

uniform mat4 iTRotMat;

layout(location = 0) out vec4 fragColor;


void main(){
	fragColor = vec4(0,0,0,1);
	vec2 realUv = vec2((uv.x * screenDimensions.x) /512.0f,((uv.y) * screenDimensions.y) /512.0f);
	//vec2 realUv = vec2(uv.x,(uv.y));
	float dx = (texture2D( colorTexture, vec2(realUv.x+1.0/512.0,realUv.y) ).x
				- texture2D( colorTexture, vec2(realUv.x,realUv.y) ).x);

	float dy = (texture2D( colorTexture, vec2(realUv.x,realUv.y+1.0/512.0f) ).x
				- texture2D( colorTexture, vec2(realUv.x,realUv.y) ).x);

	float height = texture2D( colorTexture, realUv.xy ).x;

	vec3 dxVec = vec3(1, dx, 0);
	vec3 dyVec = vec3(0, dy, 1);
	vec3 normal = normalize(cross(dyVec,dxVec));

	vec3 lightingResult = vec3(0);
	for (int i=0;i<lightCount;i++) {
		vec3 lightDir = normalize(vec3(iTRotMat * vec4(lightDirection[i],1)));
		lightDir.y = lightDir.y*1.8;
		if (lightType[i]==0) {
			lightingResult += lightIntensity[i]/2.5f;
		} else if (lightType[i]==1) {
			float cosTheta = dot(normalize(normal), -normalize(lightDir));

			cosTheta = (cosTheta>0 ? cosTheta : 0);
			cosTheta = (cosTheta<1 ? cosTheta : 1);
			
			vec3 samplePos = vec3(realUv.x, height, realUv.y);
			bool inShadow=false;
			
			if (!(abs(lightDir.y)==1)) {
				while (samplePos.x>=0 && samplePos.z>=0 &&
						samplePos.x<=1 && samplePos.z<=1 && inShadow==false) {

					samplePos.xz-=lightDir.xz/sampleDivXZ;
					samplePos.y-=lightDir.y/sampleDivY;
					if (samplePos.y < texture2D( dataTexture, samplePos.xz ).x) {
						inShadow = true;
					}
				}
			}

			if (!inShadow) {
				lightingResult += lightIntensity[i] * cosTheta * 1.5;
				//lightingResult = vec3(cosTheta,cosTheta,cosTheta);
				//return;
			} else {
				lightingResult += vec3(0,0,0);
				//fragColor = vec3(0,0,0);
				//return;
			}
		}
		
		/*else if (lightType[i]==2) {
			lightVec = lightPosition[i]-realUv;
			//if (dot(normalize(normal), normalize(lightVec))>0) {
			//if (length(lightVec)<lightRange[i]) {
				lightDist = length(lightVec);
				lightingResult += lightIntensity[i] * max(1-lightDist/ lightRange[i], 0);
			//}
			//}
		} else if (lightType[i]==3) {
			lightVec = worldSpacePosition-lightPosition[i];
			lightDist = length(lightVec);
			
			if (lightDist<lightRange[i]) {
				float angleDot = dot(normalize(lightDir),normalize(lightVec));
				float lightAngleCos = cos(lightAngle[i]*2*PI/360);
				if (angleDot>lightAngleCos) {
					lightingResult += lightIntensity[i] * max(1-lightDist / lightRange[i], 0);
				} else if (angleDot>lightAngleCos/1.02) {
					float fuzzFactor = 1-50*((lightAngleCos/angleDot)-1);
					lightingResult += lightIntensity[i] * max(1-lightDist / lightRange[i], 0) * fuzzFactor*fuzzFactor;//*fuzzFactor*fuzzFactor;
				}
			}
		}*/
	}

	fragColor = vec4(lightingResult,1);
}