#version 330 core
in vec3 in_position;
in vec3 in_normal;
in vec3 in_uv;
//in vec3 in_tangent;

out vec3 color;
out vec3 normal;
//out vec3 tangent;
out vec3 uv;
out vec3 worldSpacePosition;

vec3 realNormal;

uniform mat4 projectionMatrix;
uniform mat4 transformationMatrix;
uniform mat4 viewMatrix;
uniform mat3 normalMatrix;

vec3 up = vec3(0,1,0);

void main() {
	realNormal = normalize(normalMatrix*in_normal);
	
	gl_Position = projectionMatrix * viewMatrix * transformationMatrix * vec4(in_position, 1);

	worldSpacePosition = vec3(transformationMatrix * vec4(in_position, 1));


	color = realNormal;
	normal = realNormal;
	//tangent = normalize(normalMatrix*in_tangent);

	uv = in_uv;
}