#version 330 core

in vec2 uv;

const float xDiv=512;
const float yDiv=512;

uniform sampler2D colorTexture;
uniform sampler2D dataTexture;

uniform float playerSpeedMult;

uniform vec2 screenDimensions;

const int MAX_LIGHTS = 10;
uniform int lightCount;
uniform int lightType[MAX_LIGHTS];
uniform vec3 lightPosition[MAX_LIGHTS];
uniform vec3 lightDirection[MAX_LIGHTS];
uniform vec3 lightIntensity[MAX_LIGHTS];
uniform float lightRange[MAX_LIGHTS];
uniform float lightAngle[MAX_LIGHTS];

uniform mat4 iTRotMat;

layout(location = 0) out vec3 fragColor;

void main(){
	float[25] gaussFilter = float[](
				1.0f/273.0f, 4.0f/273.0f, 7.0f/273.0f, 4.0f/273.0f,1.0f/273.0f,
				4.0f/273.0f,16.0f/273.0f,26.0f/273.0f,16.0f/273.0f,4.0f/273.0f,
				7.0f/273.0f,26.0f/273.0f,41.0f/273.0f,26.0f/273.0f,7.0f/273.0f,
				4.0f/273.0f,16.0f/273.0f,26.0f/273.0f,16.0f/273.0f,4.0f/273.0f,
				1.0f/273.0f, 4.0f/273.0f, 7.0f/273.0f, 4.0f/273.0f,1.0f/273.0f);
	//vec2 realUv = vec2(uv.x,uv.y);
	vec2 realUv = vec2((uv.x * screenDimensions.x) /512.0f,((uv.y) * screenDimensions.y) /512.0f);
	
	vec3 outColor = vec3(0);
	for (int x=-2;x<3;x++) {
		for (int y=-2;y<3;y++) {
			outColor += texture2D( colorTexture, vec2(realUv.x+x/xDiv,realUv.y+y/yDiv) ).xyz
									* gaussFilter[(x+2)+(y+2)*5];
		}
	}
	fragColor = outColor;
}