#version 330 core

layout(location = 0) in vec2 vertex;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out vec2 fUVs;

uniform float windowHeight;
uniform float windowWidth;

void main()
{
	fUVs = uv;
	vec2 halfWindow = vec2((windowWidth / 2.0), (windowHeight / 2.0));
	gl_Position = vec4(((vertex - halfWindow) / halfWindow), 0.0, 1.0);
}