#version 330 core

in vec3 fUVs;
in vec4 position;
in vec4 prevPosition;

layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 motionVector;

uniform samplerCube colorTexture;
                                                                              
void main()
{
	fragColor = texture(colorTexture, fUVs);

	// motion vector
	vec2 current = (position.xy / position.w) * 0.5 + 0.5;
	vec2 previous = (prevPosition.xy / prevPosition.w) * 0.5 + 0.5;

	motionVector = vec4((current - previous), 0.0, 1.0);
}