#version 330 core

layout(points) in;
layout(points, max_vertices = 30) out;

in float type0[];
in vec3 position0[];
in vec3 speed0[];
in float lifetime0[];

out float type1;
out vec3 position1;
out vec3 speed1;
out float lifetime1;

uniform float time;
uniform float deltaT;
uniform sampler1D directionTexture;
uniform float launcherLifetime;
uniform float shellLifetime;
uniform float secondaryShellLifetime;

#define PARTICLE_TYPE_LAUNCHER 0.0f
#define PARTICLE_TYPE_SHELL 1.0f
#define PARTICLE_TYPE_SECONDARY_SHELL 2.0f

vec3 getDir(float uv)
{
     vec3 dir = texture(directionTexture, uv).xyz;
     dir -= vec3(0.5, 0.5, 0.5);
     return dir;
}

void main()
{
    if (type0[0] == PARTICLE_TYPE_LAUNCHER)
	{
        if (time >= launcherLifetime)
		{
            type1 = PARTICLE_TYPE_SHELL;
            position1 = position0[0];
            vec3 dir = getDir(time / 1000.0);
            dir.y = max(dir.y, 0.5);
            speed1 = normalize(dir) * 1.5;
            lifetime1 = 0.0;
            EmitVertex();
            EndPrimitive();
        }

        type1 = PARTICLE_TYPE_LAUNCHER;
        position1 = position0[0];
        speed1 = speed0[0];
        lifetime1 = 0.0;
        EmitVertex();
        EndPrimitive();
    }
    else
	{
        float t1 = lifetime0[0] / 1000.0;
        float t2 = time / 1000.0;
        vec3 deltaP = deltaT * speed0[0];
        vec3 deltaS = vec3(deltaT) * (0.0, -98.1, 0.0);

        if (type0[0] == PARTICLE_TYPE_SHELL)
		{
	        if (time < shellLifetime)
			{
	            type1 = PARTICLE_TYPE_SHELL;
	            position1 = position0[0] + deltaP;
	            speed1 = speed0[0] + deltaS;
	            lifetime1 = time;
	            EmitVertex();
	            EndPrimitive();
	        }
            else
			{
                for (int i = 0; i < 50; i++)
				{
                     type1 = PARTICLE_TYPE_SECONDARY_SHELL;
                     position1 = position0[0];
                     vec3 dir = getDir((time + i) / 1000.0);
                     speed1 = normalize(dir) * 1.5;;
                     lifetime1 = 0.0f;
                     EmitVertex();
                     EndPrimitive();
                }
            }
        }
        else
		{
            if (time < secondaryShellLifetime)
			{
                type1 = PARTICLE_TYPE_SECONDARY_SHELL;
                position1 = position0[0] + deltaP;
                speed1 = speed0[0] + deltaS;
                lifetime1 = time;
                EmitVertex();
                EndPrimitive();
            }
        }
    }
}