#version 330 core

in vec2 fUVs;

out vec4 fragColor;

uniform sampler2D colorTexture;
uniform sampler2D motionTexture;
uniform float fpsRate;

const int MAX_MOTION_SAMPLES = 25;

void main()
{
	vec2 velocity = texture(motionTexture, fUVs).rg;
	velocity *= fpsRate;

	vec2 texelSize = 1.0 / vec2(textureSize(colorTexture, 0));
	float speed = length(velocity / texelSize);
	int samples = clamp(int(speed), 1, MAX_MOTION_SAMPLES);
	vec4 result = texture(colorTexture, fUVs);

	for (int i = 1; i < samples; ++i)
	{
		vec2 offset = velocity * (float(i) / float(samples - 1) - 0.5);
		result += texture(colorTexture, fUVs + offset);
	}

	result /= float(samples);

	fragColor = result;
}