#version 330 core

in vec2 fUVs;
in vec3 worldNormal;
in vec3 viewNormal;
in vec3 viewDir;
in vec3 viewLight;
in vec4 shadowPosition;
in vec4 position;
in vec4 prevPosition;

layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 motionVector;

uniform sampler2D colorTexture;
uniform sampler2DShadow shadowTexture;
uniform vec3 lightPos;
uniform vec3 lightColor;
uniform float lightPower;
uniform bool alphaEnabled;

void main()
{
	// light
	vec3 diffuseColor = texture2D(colorTexture, fUVs).rgb;
	vec3 ambientColor = vec3(0.1, 0.1, 0.1) * diffuseColor;
	vec3 specularColor = vec3(0.3, 0.3, 0.3);

	vec3 n = normalize(viewNormal);
	vec3 l = normalize(viewLight);
	float cosTheta = clamp(dot(n, l), 0, 1);

	vec3 E = normalize(viewDir);
	vec3 R = reflect(-l, n);
	float cosAlpha = clamp(dot(E, R), 0, 1);

	float distance = length(lightPos - worldNormal);

	// shadow
	float bias = clamp(0.005 * tan(acos(cosTheta)), 0.0, 0.01);
	float offsetX = 1.0 / 800;
    float offsetY = 1.0 / 600;
    vec2 xy = (shadowPosition.xy / shadowPosition.w) * 0.5 + 0.5;
    float z = ((shadowPosition.z - bias) / shadowPosition.w) * 0.5 + 0.5;
    float shadow = 0.0;

    for (int x = -1; x <= 1; x++)
	{
        for (int y = -1; y <= 1; y++)
		{
            vec2 offsets = vec2(x * 0.2 * offsetX, y * 0.2 * offsetY);
            shadow += texture(shadowTexture, vec3(xy + offsets, z));
        }
    }

    float visibility = (0.5 + (shadow / 9.0));

	float alpha = 1.0;
	if (alphaEnabled)
		alpha = texture2D(colorTexture, fUVs).a;

	fragColor = vec4((ambientColor
			+ visibility * diffuseColor * lightColor * lightPower * cosTheta / (distance * distance)
			+ visibility * specularColor * lightColor * lightPower * pow(cosAlpha, 5.0f) / (distance * distance)
			), alpha);

	// motion vector
	vec2 current = (position.xy / position.w) * 0.5 + 0.5;
	vec2 previous = (prevPosition.xy / prevPosition.w) * 0.5 + 0.5;

	motionVector = vec4((current - previous), 0.0, 1.0);
}