#version 330 core

layout(location = 0) in vec3 vertex;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out vec2 fUVs;
out vec3 worldNormal;
out vec3 viewNormal;
out vec3 viewDir;
out vec3 viewLight;

uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;
uniform vec3 lightPos;

void main()
{
	fUVs = uv;
	gl_Position = MVP * vec4(vertex, 1.0);
	worldNormal = (M * vec4(vertex, 1.0)).xyz;
	viewNormal = (V * M * vec4(normal, 0.0)).xyz;
	viewDir = vec3(0.0, 0.0, 0.0) - (V * M * vec4(vertex, 1.0)).xyz;
	viewLight = (V * vec4(lightPos, 1.0)).xyz + viewDir;
}