#version 330 core

in vec2 fUVs;
in vec3 worldNormal;
in vec3 viewNormal;
in vec3 viewDir;
in vec3 viewLight;

out vec4 fragColor;

uniform sampler2D colorTexture;
uniform vec3 lightPos;
uniform vec3 lightColor;
uniform float lightPower;

void main()
{
	vec3 diffuseColor = texture2D(colorTexture, fUVs).rgb;
	vec3 ambientColor = vec3(0.1, 0.1, 0.1) * diffuseColor;
	vec3 specularColor = vec3(0.3, 0.3, 0.3);

	vec3 n = normalize(viewNormal);
	vec3 l = normalize(viewLight);
	float cosTheta = clamp(dot(n, l), 0.0, 1.0);

	vec3 E = normalize(viewDir);
	vec3 R = reflect(-l, n);
	float cosAlpha = clamp(dot(E, R), 0.0, 1.0);

	float distance = length(lightPos - worldNormal);

	fragColor = vec4((ambientColor
			+ diffuseColor * lightColor * lightPower * cosTheta / (distance * distance)
			+ specularColor * lightColor * lightPower * pow(cosAlpha, 5.0) / (distance * distance)
			), texture2D(colorTexture, fUVs).a);
}