#version 330 core

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

out vec2 fUVs;

uniform mat4 VP;
uniform vec3 cameraPosition;
uniform float size;

void main()
{
    vec3 position = gl_in[0].gl_Position.xyz;
    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 right = cross(normalize(cameraPosition - position), up) * size;

    position -= right;
    gl_Position = VP * vec4(position, 1.0);
    fUVs = vec2(0.0, 0.0);
    EmitVertex();

    position.y += size;
    gl_Position = VP * vec4(position, 1.0);
    fUVs = vec2(0.0, 1.0);
    EmitVertex();

    position.y -= size;
    position += right;
    gl_Position = VP * vec4(position, 1.0);
    fUVs = vec2(1.0, 0.0);
    EmitVertex();

    position.y += size;
    gl_Position = VP * vec4(position, 1.0);
    fUVs = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();
}