#version 330

in vec3 position;
in vec3 normal;
in vec2 uv;

out vec3 cameraNormal;
out vec3 worldPosition;
out vec3 cameraEyeDirection;
out vec3 cameraLightDirection;
out vec2 fragmentUV;

uniform mat4 modelMatrix;
uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;

void main() {
	fragmentUV = uv;
	
	cameraNormal = normalize(vec3(viewMatrix * modelMatrix * vec4(normal,0.0)));

	gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(position, 1);

	
	worldPosition = (modelMatrix * vec4(position, 1)).xyz;
	
	vec3 cameraVertexPosition = ( viewMatrix * modelMatrix * vec4(position,1)).xyz;
	cameraEyeDirection = vec3(0,0,0) - cameraVertexPosition;

	//vec3 LightPosition_cameraspace = ( viewMatrix * vec4(LightPosition_worldspace,1)).xyz;
	//LightDirection_cameraspace = LightPosition_cameraspace + EyeDirection_cameraspace;
	cameraLightDirection = (viewMatrix * vec4(1,1,1,0)).xyz;	
}