#version 330

in vec3 cameraNormal;
in vec3 worldPosition;
in vec3 cameraEyeDirection;
in vec3 cameraLightDirection;
in vec2 fragmentUV;

out vec3 fragColor;

uniform sampler2D colorTexture;

void main() {
	vec3 lightColor = vec3(1, 1, 1);
	float lightPower = 1.0f;
	float shininess = 5;
	
	vec3 textureColor = texture(colorTexture, fragmentUV).rgb;
	vec3 ambientColor = vec3(0.1, 0.1, 0.1);
	vec3 specularColor = vec3(0.3, 0.3, 0.3);

	
	vec3 n = normalize(cameraNormal);
	vec3 l = normalize(cameraLightDirection);
	float cosTheta = clamp(dot(n, l), 0, 1);
	
	vec3 E = normalize(cameraEyeDirection);
	vec3 R = reflect(-l, n);
	float cosAlpha = clamp(dot(E, R), 0, 1);
	
	fragColor = ambientColor * textureColor + textureColor * lightColor * lightPower * cosTheta + specularColor * lightColor * lightPower * pow(cosAlpha, shininess);
}