#include "RendererVolumeBooster.glsl"

uniform sampler3D samDataVolume;
uniform sampler3D samSelectionVolume;
uniform sampler2D samBackgroundSelectionColorTransferFunction;
uniform sampler2D samGhostSelectionColorTransferFunction;
uniform sampler2D samBackgroundLightingTransferFunction;
uniform sampler2D samGhostLightingTransferFunction;
uniform sampler2D samSelectionLightingTransferFunction;
uniform samplerRectShadow samGeometryDepth;
uniform samplerRectShadow samGhostCutoutDepth;
uniform samplerRectShadow samSelectionCutoutDepth;
uniform float fCutoutGhost;
uniform float fCutoutSelection;
uniform vec3 vecDirection;
uniform vec3 vecScale;

void main()
{
	vec3 vecFragment = gl_FragCoord.xyz * vecScale;

	discard(shadowRect(samGeometryDepth,vecFragment).z);
	
	vec3 vecOffset = GetOffset(vecFragment)*vecDirection;
	vec3 vecPositionBackground = gl_TexCoord[0].xyz - vecOffset;
	vec3 vecPositionSelection = gl_TexCoord[1].xyz - vecOffset;

	vec4 vecSampleDataVolumeBackground = GetDataVolumeSample(samDataVolume,vecPositionBackground);
	vec4 vecSampleDataVolumeSelection = GetDataVolumeSample(samDataVolume,vecPositionSelection);

	float fSampleSelectionActive = GetSelectionVolumeSample(samSelectionVolume,vecPositionSelection);
	float fSampleGhostActive = GetSelectionVolumeSample(samSelectionVolume,vecPositionBackground);
	float fSampleBackgroundActive = 1.0 - fSampleGhostActive;

	vec4 vecColorBackground = GetColor(samBackgroundSelectionColorTransferFunction,vec2(vecSampleDataVolumeBackground.a,0.0));
	vec4 vecColorGhost = GetColor(samGhostSelectionColorTransferFunction,vec2(vecSampleDataVolumeBackground.a,0.0));	
	vec4 vecColorSelection = GetColor(samBackgroundSelectionColorTransferFunction,vec2(0.0,vecSampleDataVolumeSelection.a));
	vec4 vecColorBackgroundSelection = GetColor(samBackgroundSelectionColorTransferFunction,vec2(vecSampleDataVolumeBackground.a,vecSampleDataVolumeSelection.a));
	vec4 vecColorGhostSelection = GetColor(samGhostSelectionColorTransferFunction,vec2(vecSampleDataVolumeBackground.a,vecSampleDataVolumeSelection.a));
	
	vec3 vecProductsBackground = GetProducts(gl_TexCoord[2].xyz,gl_TexCoord[3].xyz,vecSampleDataVolumeBackground.xyz);
	vec3 vecProductsSelection = GetProducts(gl_TexCoord[4].xyz,gl_TexCoord[5].xyz,vecSampleDataVolumeSelection.xyz);

	vec4 vecLightingBackground = GetLighting(samBackgroundLightingTransferFunction,vecProductsBackground);
	vec4 vecLightingGhost = GetLighting(samGhostLightingTransferFunction,vecProductsBackground);
	vec4 vecLightingSelection = GetLighting(samSelectionLightingTransferFunction,vecProductsSelection);
	vec4 vecLightingBackgroundSelection = GetLighting(vecLightingBackground, fSampleBackgroundActive, vecLightingSelection, fSampleSelectionActive);
	vec4 vecLightingGhostSelection = GetLighting(vecLightingGhost, fSampleGhostActive, vecLightingSelection, fSampleSelectionActive);

	float fGhosting = max(fCutoutGhost*shadow2DRect(samGhostCutoutDepth,vecFragment).z,fCutoutSelection*shadow2DRect(samSelectionCutoutDepth,vecFragment).z);
	vecColorBackground = GetShaded(vecColorBackground,vecLightingBackground,fGhosting);
	vecColorGhost = GetShaded(vecColorGhost,vecLightingGhost);
	vecColorSelection = GetShaded(vecColorSelection,vecLightingSelection);
	vecColorBackgroundSelection = GetShaded(vecColorBackgroundSelection,vecLightingBackgroundSelection);
	vecColorGhostSelection = GetShaded(vecColorGhostSelection,vecLightingGhostSelection);

	float fBackgroundSelectionActive = (min(min(fSampleSelectionActive,vecColorSelection.a),min(fSampleBackgroundActive,vecColorBackground.a)));
	float fGhostSelectionActive = (min(min(fSampleSelectionActive,vecColorSelection.a),min(fSampleGhostActive,vecColorGhost.a)));

	if (fBackgroundSelectionActive > 0.0)
		fBackgroundSelectionActive = min(min(fSampleBackgroundActive,fSampleSelectionActive),vecColorBackgroundSelection.a);

	if (fGhostSelectionActive > 0.0)
		fGhostSelectionActive = min(min(fSampleGhostActive,fSampleSelectionActive),vecColorGhostSelection.a);

	float fSelectionActive = min(min(fSampleSelectionActive,vecColorSelection.a),1.0-max(fBackgroundSelectionActive,fGhostSelectionActive));
	float fBackgroundActive = min(min(fSampleBackgroundActive,vecColorBackground.a),1.0-fBackgroundSelectionActive);
	float fGhostActive = min(min(fSampleGhostActive,vecColorGhost.a),1.0-fGhostSelectionActive);

	vec4 vecColorVolume;
	vecColorVolume = (vecColorSelection*fSelectionActive + vecColorBackground*fBackgroundActive + vecColorGhost*fGhostActive + vecColorBackgroundSelection*fBackgroundSelectionActive + vecColorGhostSelection*fGhostSelectionActive) / (fSelectionActive + fBackgroundActive + fGhostActive + fBackgroundSelectionActive + fGhostSelectionActive);
	vecColorVolume.a = max(fSelectionActive,max(max(fBackgroundActive,fGhostActive),max(fBackgroundSelectionActive,fGhostSelectionActive)));

	gl_FragColor = vecColorVolume;
	gl_FragColor.rgb *= gl_FragColor.a;	
}