#include "RendererVolumeBooster.glsl"

uniform sampler3D samDataVolume;
uniform sampler3D samSelectionVolume;
uniform sampler2D samBackgroundSelectionColorTransferFunction;
uniform sampler2D samGhostSelectionColorTransferFunction;
uniform sampler2D samBackgroundLightingTransferFunction;
uniform sampler2D samGhostLightingTransferFunction;
uniform sampler2D samSelectionLightingTransferFunction;
uniform samplerRectShadow samGeometryDepth;
uniform samplerRectShadow samGhostCutoutDepth;
uniform samplerRectShadow samSelectionCutoutDepth;
uniform vec3 vecDirection;
uniform vec3 vecScale;

void main()
{
	vec3 vecFragment = gl_FragCoord.xyz * vecScale;

	discard(shadowRect(samGeometryDepth,vecFragment).z);
	discard(shadowRect(samGhostCutoutDepth,vecFragment).z);
	discard(shadowRect(samSelectionCutoutDepth,vecFragment).z);
	
	vec3 vecOffset = GetOffset(vecFragment)*vecDirection;
	vec3 vecPositionBackground = gl_TexCoord[0].xyz - vecOffset;
	
	vec4 vecSampleDataVolume = GetDataVolumeSample(samDataVolume,vecPositionBackground );
	vec4 vecColorBackground = GetColor(samBackgroundSelectionColorTransferFunction,vec2(vecSampleDataVolume.a,0.0));
		
	vec3 vecProducts = GetProducts(gl_TexCoord[2].xyz,gl_TexCoord[3].xyz,vecSampleDataVolume.xyz);
	vec4 vecLighting = GetLighting(samBackgroundLightingTransferFunction,vecProducts);
	gl_FragColor = GetShaded(vecColorBackground,vecLighting);	
	gl_FragColor.rgb *= gl_FragColor.a;
/*
	if (gl_FragColor.a > 0.0)
	{
		gl_FragColor.rgb = GetOffset(gl_FragCoord);
		gl_FragColor.a = 1.0;
	}
*/	
}