vec4 GetDataVolumeSample(const uniform sampler3D samDataVolume, vec3 fPosition)
{
	return texture3D(samDataVolume,fPosition);
}

float GetSelectionVolumeSample(const uniform sampler3D samSelectionVolume,  vec3 vecPosition)
{
	return texture3D(samSelectionVolume,vecPosition).a;
}

vec4 GetColor(const uniform sampler2D samColorTransferFunction, vec2 vecSample)
{
	return texture2D(samColorTransferFunction,vecSample);
}

vec3 GetProducts(vec3 vecLight, vec3 vecHalf, vec3 vecGradient)
{
	vec3 vecProducts = vec3(0.0,0.0,0.0);
	float fLength = length(vecGradient);

	if (fLength > 0.0)
	{
		vec3 fNormal = vecGradient / fLength;
		vecProducts.x = dot(fNormal,normalize(vecLight));
		vecProducts.y = dot(fNormal,normalize(vecHalf));
		vecProducts.z = fLength;
	}

	return vecProducts;
}

vec4 GetLighting(const uniform sampler2D samLightingTransferFunction, vec3 vecProducts)
{
	vec4 vecLighting = vec4(0.0,0.0,0.0,1.0);
	vecLighting = texture2D(samLightingTransferFunction,(vecProducts.xy + 1.0)*0.5);
	vecLighting.a = min(1.0,vecLighting.a+(1.0-vecProducts.z));
	return vecLighting;
}

vec4 GetLighting(vec4 vecLightingOne, float fFactorOne, vec4 vecLightingTwo, float fFactorTwo)
{
	float fFactorSum = fFactorOne + fFactorTwo;
	vec4 vecLighting = vecLightingOne * fFactorOne + vecLightingTwo*fFactorTwo;

	if (fFactorSum > 0.0)
		vecLighting /= fFactorSum;

	return vecLighting;
}

vec4 GetShaded(vec4 vecColor, vec4 vecLighting)
{
	vec4 vecShaded = vecColor;
	vecShaded.rgb = vecLighting.r + vecColor.rgb * vecLighting.g + vecLighting.b;

	if (vecLighting.a > 0.0)
		vecShaded.a /= vecLighting.a;

	return vecShaded;
}

vec4 GetShaded(vec4 vecColor, vec4 vecLighting, float fGhosting)
{
	vec4 vecShaded = vecColor;
	vecShaded.rgb = vecLighting.r + vecColor.rgb * vecLighting.g + vecLighting.b;
	vecShaded.a *= min(1.0,(1.0-fGhosting));

	if (vecLighting.a > 0.0)
		vecShaded.a /= vecLighting.a;

	return vecShaded;
}

vec4 GetBlended(vec4 vecColorOne, vec4 vecColorTwo)
{
	vec4 vecColor;
	vecColor.rgb = vecColorOne.rgb*vecColorOne.a + vecColorTwo.rgb*vecColorTwo.a;
	vecColor.a = vecColorOne.a + vecColorTwo.a;

	if (vecColor.a > 0.0)
		vecColor.rgb /= vecColor.a;

	return vecColor;
}

vec4 GetBlended(vec4 vecColorOne, vec4 vecColorTwo, vec4 vecColorThree)
{
	vec4 vecColor;
	vecColor.rgb = vecColorOne.rgb*vecColorOne.a + vecColorTwo.rgb*vecColorTwo.a + vecColorThree.rgb*vecColorThree.a;
	vecColor.a = vecColorOne.a + vecColorTwo.a + vecColorThree.a;

	if (vecColor.a > 0.0)
		vecColor.rgb /= vecColor.a;

	return vecColor;
}

vec4 GetBlended(vec4 vecColorOne, vec4 vecColorTwo, vec4 vecColorThree, vec4 vecColorFour)
{
	vec4 vecColor;
	vecColor.rgb = vecColorOne.rgb*vecColorOne.a + vecColorTwo.rgb*vecColorTwo.a + vecColorThree.rgb*vecColorThree.a + vecColorFour.rgb*vecColorFour.a;
	vecColor.a = vecColorOne.a + vecColorTwo.a + vecColorThree.a + vecColorFour.a;

	if (vecColor.a > 0.0)
		vecColor.rgb /= vecColor.a;

	return vecColor;
}

vec4 GetBlended(vec4 vecColorOne, vec4 vecColorTwo, vec4 vecColorThree, vec4 vecColorFour, vec4 vecColorFive)
{
	vec4 vecColor;
	vecColor.rgb = vecColorOne.rgb*vecColorOne.a + vecColorTwo.rgb*vecColorTwo.a + vecColorThree.rgb*vecColorThree.a + vecColorFour.rgb*vecColorFour.a + vecColorFive.rgb*vecColorFive.a;
	vecColor.a = vecColorOne.a + vecColorTwo.a + vecColorThree.a + vecColorFour.a + vecColorFive.a;

	if (vecColor.a > 0.0)
		vecColor.rgb /= vecColor.a;

	return vecColor;
}

float GetOffset(vec3 vecPosition)
{
/*
	vec4 vecAddition = mod(vecPosition.xxxx,vec4(2.0,3.0,5.0,7.0)) + mod(vecPosition.yyyy,vec4(2.0,3.0,5.0,7.0));
	vec4 vecModulo = mod(vecAddition,vec4(2.0,5.0,7.0,11.0));	
	float fOffset = abs(60.0*vecModulo.x + 15.0*vecModulo.y + 10.0*vecModulo.z + 6.0*vecModulo.w) / 240.0;
	return fOffset;
*/	


	vec4 vecAddition = mod(vecPosition.xxxx,vec4(2.0,3.0,5.0,7.0)) + mod(vecPosition.yyyy,vec4(2.0,3.0,5.0,7.0));
	vec4 vecModulo = mod(vecAddition,vec4(2.0,5.0,7.0,11.0));	
	float fOffset = abs(60.0*vecModulo.x + 15.0*vecModulo.y + 10.0*vecModulo.z + 6.0*vecModulo.w) / 240.0;
	return fOffset;
}

