#pragma once

#include "volumeshop.h"

#include "Environment.h"
#include "Interactor.h"
#include "Vector.h"
#include "Timer.h"
#include "Matrix.h"
#include <float.h>
#include <math.h>

class InteractorOrthographicCamera : public Interactor
{
public:

	InteractorOrthographicCamera(Environment & envEnvironment) : m_envEnvironment(envEnvironment)
	{
	};

	virtual ~InteractorOrthographicCamera()
	{
	};

	Environment & GetEnvironment()
	{
		return m_envEnvironment;
	};

	virtual void idle()
	{
	};

	virtual void underlay()
	{
	};

	virtual void display()
	{
	};

	virtual void overlay()
	{
	};

	virtual void reshape(const unsigned int uWidth, const unsigned int uHeight)
	{
		const Vector vecEye(0.0f,0.0f,sqrtf(3.0f));
		const Vector vecCenter(0.0f,0.0f,0.0f);
		const Vector vecUp(0.0f,1.0f,0.0f);

		const Vector vecF = (vecCenter - vecEye).GetNormalized();
		const Vector vecS = vecF.GetCross(vecUp.GetNormalized());
		const Vector vecU = vecS.GetCross(vecF);

		Matrix matViewingPreTransformation(vecS.GetX(),vecS.GetY(),vecS.GetZ(),0.0f, vecU.GetX(),vecU.GetY(),vecU.GetZ(),0.0f, -vecF.GetX(),-vecF.GetY(),-vecF.GetZ(),0.0f, 0.0f,0.0f,0.0f,1.0f);
		matViewingPreTransformation.translate(-vecEye);
		GetEnvironment().SetViewingPreTransformation(matViewingPreTransformation);
/*
		Matrix matViewingPostTransformation;
		matViewingPostTransformation.translate(-vecEye);

		GetEnvironment().SetViewingPostTransformation(matViewingPostTransformation);
*/

		const float fAspectRatio = float(uWidth) / float(uHeight);
		const float fLeft = -1.0f * fAspectRatio;
		const float fRight = 1.0f * fAspectRatio;
		const float fBottom = -1.0f;
		const float fTop = 1.0f;
		const float fNear = -1.5f*sqrtf(3.0f);
		const float fFar = 1.5f*sqrtf(3.0f);
		const float fTx = (fRight + fLeft) / (fRight - fLeft);
		const float fTy = (fTop + fBottom) / (fTop - fBottom);
		const float fTz = (fFar + fNear) / (fFar - fNear);

		Matrix matProjectionPreTransformation(2.0f/(fRight-fLeft),0.0f,0.0f,fTx, 0.0f,2.0f/(fTop-fBottom),0.0f,fTy, 0.0f,0.0f,-2.0f/(fFar-fNear),fTz,  0.0f,0.0f,0.0f,1.0f);
		//matProjectionPreTransformation *= matViewingPreTransformation;
		GetEnvironment().SetProjectionPreTransformation(matProjectionPreTransformation);

		GetEnvironment().update();
	};

	virtual void mousePress(const MouseEvent & mouEvent)
	{
	};

	virtual void mouseRelease(const MouseEvent & mouEvent)
	{
	};


	virtual void mouseMove(const MouseEvent & mouEvent)
	{
	};

	virtual void keyboardPress(const KeyboardEvent & keyEvent) 
	{
	};

	virtual void keyboardRelease(const KeyboardEvent & keyEvent)
	{
	};

private:

	Environment & m_envEnvironment;
};