// main.cpp : Defines the entry point for the console application.
//

#include "volumeshop.h"

#include <QApplication>
#include <QMainWindow>

#include <iostream>
#include <string>
#include <vector>

#include "ImporterPlugin.h"
#include "ExporterPlugin.h"
#include "InteractorPlugin.h"
#include "RendererPlugin.h"
#include "Timer.h"
#include "Image.h"

#include "QMainframe.h"
#include "QViewer.h"
#include "QSidebar.h"

#include <sstream>
#include <fstream>
#include "Element.h"

int main(int argc, char **argv)
{
	try
	{
		/*
		std::cout << std::endl << "Available importer plugins:" << std::endl;

		for (ImporterPlugin::Iterator i("*.dll"); !i.IsAtEnd(); ++i)
		{
			std::cout << *i << ": " << i.GetName() << " (" << i.GetDescription() << ")" << std::endl;
		}

		std::cout << std::endl << "Available exporter plugins:" << std::endl;

		for (ExporterPlugin::Iterator i("*.dll"); !i.IsAtEnd(); ++i)
		{
			std::cout << *i << ": " << i.GetName() << " (" << i.GetDescription() << ")" << std::endl;
		}

		std::cout << std::endl << "Available interactor plugins:" << std::endl;

		for (InteractorPlugin::Iterator i("*.dll"); !i.IsAtEnd(); ++i)
		{
			std::cout << *i << ": " << i.GetName() << " (" << i.GetDescription() << ")" << std::endl;
		}

		std::cout << std::endl << "Available renderer plugins:" << std::endl;

		for (RendererPlugin::Iterator i("*.dll"); !i.IsAtEnd(); ++i)
		{
			std::cout << *i << ": " << i.GetName() << " (" << i.GetDescription() << ")" << std::endl;
		}
	*/
		QGLFormat defaultFormat = QGLFormat::defaultFormat();
		defaultFormat.setDepth(true);
		defaultFormat.setAlpha(true);
		defaultFormat.setDoubleBuffer(true);
		QGLFormat::setDefaultFormat(defaultFormat);
		QApplication application( argc, argv );

		QMainframe mainframe;
		mainframe.show();

		mainframe.resize(1053,787);
		//mainframe.resize(1056-8-256,804-34-256);
	/*
		mainframe.setMaximumWidth(800-8);
		mainframe.setMaximumHeight(571-34-23+52);
		mainframe.setFixedWidth(800-8);
		mainframe.setFixedHeight(571-34-23+52);
		mainframe.resize(800-8,571-34-23+52);
	*/	
		

		Environment envEnvironment;
		mainframe.initialize(&envEnvironment);

		InteractorPlugin interactorOrthographicCamera(envEnvironment,"plugin_interactor_orthographiccamera.dll");
		InteractorPlugin interactorPerspectiveCamera(envEnvironment,"plugin_interactor_perspectivecamera.dll");
		InteractorPlugin interactorViewingTrackball(envEnvironment,"plugin_interactor_viewingtrackball.dll");
		InteractorPlugin interactorDataTrackball(envEnvironment,"plugin_interactor_datatrackball.dll");
		InteractorPlugin interactorSelectionTrackball(envEnvironment,"plugin_interactor_selectiontrackball.dll");
		InteractorPlugin interactorSelectionPainter(envEnvironment,"plugin_interactor_selectionpainter.dll");	

		std::list<Plugin *> listCameras;
		listCameras.push_back(&interactorOrthographicCamera);
		listCameras.push_back(&interactorPerspectiveCamera);
		mainframe.GetViewer()->add(listCameras);

		std::list<Plugin *> listEditors;
		listEditors.push_back(&interactorViewingTrackball);
		listEditors.push_back(&interactorDataTrackball);
		listEditors.push_back(&interactorSelectionTrackball);
		listEditors.push_back(&interactorSelectionPainter);
		mainframe.GetViewer()->add(listEditors);


		for (RendererPlugin::Iterator i("*.dll"); !i.IsAtEnd(); ++i)
		{
			std::cout << *i << ": " << i.GetName() << " (" << i.GetDescription() << ")" << std::endl;
			RendererPlugin *pRenderer = new RendererPlugin(envEnvironment,*i);
			mainframe.GetViewer()->add(pRenderer);
		}

		mainframe.GetViewer()->SetEnabled(&interactorOrthographicCamera,true);
		mainframe.GetViewer()->SetEnabled(&interactorViewingTrackball,true);

		application.connect( &application, SIGNAL(lastWindowClosed()), &application, SLOT(quit()) );
		return application.exec();
	}
	catch (Exception e)
	{
		std::cerr << "A critical error occured: " << e << std::endl << std::endl;
		exit(EXIT_FAILURE);
	}
	catch (...)
	{
		std::cerr << "An unknown critical error occured." << std::endl << std::endl;
		exit(EXIT_FAILURE);
	}
}

