#pragma once

#include "volumeshop.h"
#include "Vector.h"

class SelectionVoxel
{
public:

	SelectionVoxel()
	{
		Set(0.0f);
	};

	SelectionVoxel(const SelectionVoxel & selOther)
	{
		m_fValue = selOther.m_fValue;
	};

	SelectionVoxel(const float fValue)
	{
		Set(fValue);
	};

	~SelectionVoxel()
	{
	};

	void Set(const float fValue)
	{
		m_fValue = fValue;
	};

	const float Get() const
	{
		return m_fValue;
	};

	const bool operator==(const SelectionVoxel &selOther) const
	{
		return (Get() == selOther.Get());
	};

	const bool operator!=(const SelectionVoxel &selOther) const
	{
		return !(*this == selOther);
	};

	const bool operator>(const SelectionVoxel &selOther) const
	{
		return Get() > selOther.Get();
	};

	const bool operator>=(const SelectionVoxel &selOther) const
	{
		return Get() >= selOther.Get();
	};

	const bool operator<(const SelectionVoxel &selOther) const
	{
		return Get() < selOther.Get();
	};

	const bool operator<=(const SelectionVoxel &selOther) const
	{
		return Get() <= selOther.Get();
	};

	const SelectionVoxel & operator+=(const SelectionVoxel & selOther)
	{
		m_fValue += selOther.m_fValue;
		return *this;
	};

	const SelectionVoxel & operator-=(const SelectionVoxel & selOther)
	{
		m_fValue -= selOther.m_fValue;
		return *this;
	};

	const SelectionVoxel & operator*=(const float & fOther)
	{
		m_fValue *= fOther;
		return *this;
	};

	const SelectionVoxel & operator/=(const float & fOther)
	{
		m_fValue /= fOther;
		return *this;
	};

	const SelectionVoxel operator+(const SelectionVoxel & selOther) const
	{
		SelectionVoxel selNew = *this;
		selNew += selOther;
		return selNew;
	};

	const SelectionVoxel operator-(const SelectionVoxel & selOther) const
	{
		SelectionVoxel selNew = *this;
		selNew -= selOther;
		return selNew;
	};

	const SelectionVoxel operator*(const float & fOther) const
	{
		SelectionVoxel selNew = *this;
		selNew *= fOther;
		return selNew;
	};

	const SelectionVoxel operator/(const float & fOther) const
	{
		SelectionVoxel selNew = *this;
		selNew /= fOther;
		return selNew;
	};

private:
	float m_fValue;
};

template <>
inline GLenum glInternalFormat<SelectionVoxel>()
{
/*
	if (GLEW_ARB_texture_float)
		return GL_ALPHA16F_ARB;
	else
*/
		return GL_ALPHA;
};

template <>
inline GLenum glFormat<SelectionVoxel>()
{
	return GL_ALPHA;
};

template <>
inline GLenum glType<SelectionVoxel>()
{
	return GL_FLOAT;
};
