#pragma once

#include "volumeshop.h"

#include "BasicPlugin.h"
#include "Renderer.h"

#define DECLARE_RENDERERPLUGIN(name) DECLARE_PLUGIN(Renderer,name)
#define DEFINE_RENDERERPLUGIN(name,description,icon) DEFINE_PLUGIN(Renderer,name,description,icon)

class RendererPlugin : public BasicPlugin<Renderer>
{
public:
	RendererPlugin(Environment & envEnvironment, const std::string & strFilename) : BasicPlugin<Renderer>(envEnvironment,strFilename)
	{
	};

	virtual ~RendererPlugin()
	{
	}

	virtual void idle()
	{
		if (GetInstance())
			GetInstance()->idle();
	};

	virtual void underlay()
	{
		if (GetInstance())
			GetInstance()->underlay();
	};

	virtual void display()
	{
		if (GetInstance())
			GetInstance()->display();
	};

	virtual void overlay()
	{
		if (GetInstance())
			GetInstance()->overlay();
	};

	virtual void reshape(const unsigned int uWidth, const unsigned int uHeight)
	{
		if (GetInstance())
			GetInstance()->reshape(uWidth,uHeight);
	};


	virtual void mousePress(const MouseEvent & mouEvent)
	{
		if (GetInstance())
			GetInstance()->mousePress(mouEvent);
	};

	virtual void mouseRelease(const MouseEvent & mouEvent)
	{
		if (GetInstance())
			GetInstance()->mouseRelease(mouEvent);
	};

	virtual void mouseMove(const MouseEvent & mouEvent)
	{
		if (GetInstance())
			GetInstance()->mouseMove(mouEvent);
	};

	virtual void keyboardPress(const KeyboardEvent & keyEvent)
	{
		if (GetInstance())
			GetInstance()->keyboardPress(keyEvent);
	};

	virtual void keyboardRelease(const KeyboardEvent & keyEvent)
	{
		if (GetInstance())
			GetInstance()->keyboardRelease(keyEvent);
	};
};
