#pragma once

#include "volumeshop.h"

#include "Environment.h"
#include "Image.h"

class Plugin
{
public:

	Plugin(Environment & envEnvironment) : m_envEnvironment(envEnvironment)
	{
	};

	virtual ~Plugin()
	{
	};

	Environment & GetEnvironment()
	{
		return m_envEnvironment;
	};

	virtual void initialize() = 0;
	virtual void uninitialize() = 0;
	virtual const bool IsInitialized() const = 0;
	virtual const std::string GetType() const = 0;
	virtual const std::string GetName() const = 0;
	virtual const std::string GetDescription() const = 0;
	virtual const Image GetIcon() const = 0;

private:

	Environment & m_envEnvironment;
};