#pragma once

#include "volumeshop.h"

#include <iostream>
#include <string>
#include <math.h>

#include "Attribute.h"
#include "Element.h"

class Label
{
public:
	Label() : m_bVisible(true)
	{
	};

	~Label()
	{
	};

	void SetText(const std::string & strText)
	{
		m_strText = strText;
	};

	const std::string & GetText() const
	{
		return m_strText;
	};

	void SetPosition(const float vfPosition[2])
	{
		m_vfPosition[0] = vfPosition[0];
		m_vfPosition[1] = vfPosition[1];
	};

	void SetPosition(const float fX, const float fY)
	{
		m_vfPosition[0] = fX;
		m_vfPosition[1] = fY;
	};

	void SetPositionX(const float fX)
	{
		m_vfPosition[0] = fX;
	};

	void SetPositionY(const float fY)
	{
		m_vfPosition[1] = fY;
	};

	const float GetPositionX() const
	{
		return m_vfPosition[0];
	};

	const float GetPositionY() const
	{
		return m_vfPosition[1];
	};

	const float * GetPosition() const
	{
		return (float*) m_vfPosition;
	};

	void SetAnchor(const float vfAnchor[])
	{
		m_vfAnchor[0] = vfAnchor[0];
		m_vfAnchor[1] = vfAnchor[1];
	};

	void SetAnchor(const float fX, const float fY)
	{
		m_vfAnchor[0] = fX;
		m_vfAnchor[1] = fY;
	};

	void SetAnchorX(const float fX)
	{
		m_vfAnchor[0] = fX;
	};

	void SetAnchorY(const float fY)
	{
		m_vfAnchor[1] = fY;
	};

	const float GetAnchorX() const
	{
		return m_vfAnchor[0];
	};

	const float GetAnchorY() const
	{
		return m_vfAnchor[1];
	};

	const float * GetAnchor() const
	{
		return (float*) m_vfAnchor;
	};

	void SetLink(const float vfLink[])
	{
		m_vfLink[0] = vfLink[0];
		m_vfLink[1] = vfLink[1];
	};

	void SetLink(const float fX, const float fY)
	{
		m_vfLink[0] = fX;
		m_vfLink[1] = fY;
	};

	void SetLinkX(const float fX)
	{
		m_vfLink[0] = fX;
	};

	void SetLinkY(const float fY)
	{
		m_vfLink[1] = fY;
	};

	const float GetLinkX() const
	{
		return m_vfLink[0];
	};

	const float GetLinkY() const
	{
		return m_vfLink[1];
	};

	const float * GetLink() const
	{
		return (float*) m_vfLink;
	};

	void SetWidth(const float fWidth)
	{
		m_fWidth = fWidth;
	};

	void SetHeight(const float fHeight)
	{
		m_fHeight = fHeight;
	};

	void SetDepth(const float fDepth)
	{
		m_fDepth = fDepth;
	};

	const float GetWidth() const
	{
		return m_fWidth;
	};

	const float GetHeight() const
	{
		return m_fHeight;
	};

	const float GetDepth() const
	{
		return m_fDepth;
	};

	void SetVisible(const bool bVisible)
	{
		m_bVisible = bVisible;
	};

	const bool IsVisible() const
	{
		return m_bVisible;
	};

	const bool IsInside(const float vfPosition[]) const
	{
		if (vfPosition[0] >= m_vfPosition[0] && vfPosition[1] >= m_vfPosition[1] && vfPosition[0] <= (m_vfPosition[0]+m_fWidth) && vfPosition[1] <= (m_vfPosition[1]+m_fHeight))
			return true;

		return false;
	};

	const bool IsInside(const float fX, const float fY) const
	{
		const float vfPosition[2] = {fX,fY};
		return IsInside(vfPosition);
	};

	const bool IsOverlapping(const Label & labOther) const
	{
		return labOther.GetPositionX() < GetPositionX()+GetWidth() && labOther.GetPositionX()+labOther.GetWidth() > GetPositionX() && labOther.GetPositionY() < GetPositionY()+GetHeight() && labOther.GetPositionY()+labOther.GetHeight() > GetPositionY();
	};

	operator Element() const
	{
		Element eleElement("label");
		return eleElement;		
	};

	Label & operator=(const Element & eleElement)
	{
		return *this;
	};

private:
	std::string m_strText;
	float m_vfPosition[2];
	float m_vfAnchor[2];
	float m_vfLink[2];
	float m_fWidth;
	float m_fHeight;
	float m_fDepth;
	bool m_bVisible;
};

inline std::ostream & operator<< (std::ostream & os, const Label & vecLabel)
{
	return os;
}