#pragma once

#include "volumeshop.h"
#include "Event.h"

class Interactor
{
public:
	virtual void idle() = 0;
	virtual void underlay() = 0;
	virtual void display() = 0;
	virtual void overlay() = 0;
	virtual void reshape(const unsigned int uWidth, const unsigned int uHeight) = 0;
	virtual void mousePress(const MouseEvent & mouEvent) = 0;
	virtual void mouseRelease(const MouseEvent & mouEvent) = 0;
	virtual void mouseMove(const MouseEvent & mouEvent) = 0;
	virtual void keyboardPress(const KeyboardEvent & keyEvent) = 0;
	virtual void keyboardRelease(const KeyboardEvent & keyEvent) = 0;
};