#pragma once

#include "volumeshop.h"

#include "BasicPlugin.h"
#include "Importer.h"

#define DECLARE_IMPORTERPLUGIN(name) DECLARE_PLUGIN(Importer,name)
#define DEFINE_IMPORTERPLUGIN(name,description,icon) DEFINE_PLUGIN(Importer,name,description,icon)

class ImporterPlugin : public BasicPlugin<Importer>
{
public:
	ImporterPlugin(Environment & envEnvironment, const std::string & strFilename) : BasicPlugin<Importer>(envEnvironment,strFilename)
	{
	};

	virtual ~ImporterPlugin()
	{
	};

	virtual const bool IsAccepted(const std::string & strFilename)
	{
		if (GetInstance())
			return GetInstance()->IsAccepted(strFilename);

		return false;
	};

	virtual void load(const std::string & strFilename)
	{
		if (GetInstance())
			GetInstance()->load(strFilename);
	};

	virtual const float GetProgress()
	{
		if (GetInstance())
			return GetInstance()->GetProgress();

		return 0.0f;
	};
};
