#pragma once

#include "volumeshop.h"

#include <vector>
#include <math.h>
#include "Vector.h"

class Gaussian
{
public:

	Gaussian(const unsigned int uSize) : m_uSize(uSize)
	{
		const float fSigma = float(uSize) / 6.0f;
		const float fSigma2 = fSigma*fSigma;
		const float fCenter = float(uSize) * 0.5f;
		const Vector vecCenter(fCenter,fCenter,fCenter);

		m_vecValues.resize(uSize*uSize*uSize);
		unsigned int uIndex = 0;

		for (unsigned int k=0; k < uSize; k++)
		{
			for (unsigned int j=0; j < uSize; j++)
			{
				for (unsigned int i=0; i < uSize; i++)
				{
					const Vector vecDifference = Vector(float(i),float(j),float(k)) - vecCenter;
					const float fValue = expf(- vecDifference.GetDot(vecDifference) / (2.0f * fSigma2));
					m_vecValues[uIndex++] = fValue;
				}
			}
		}
	};

	~Gaussian()
	{
	};

	const float Get(const int iX, const int iY, const int iZ) const
	{
		const unsigned int iHalfSize = int(m_uSize) / 2;
		return m_vecValues[unsigned int(iX + iHalfSize) + unsigned int(iY + iHalfSize) * m_uSize + unsigned int(iZ + iHalfSize) * m_uSize * m_uSize];
	};

	const unsigned int GetSize() const
	{
		return m_uSize;
	};

private:
	std::vector<float> m_vecValues;
	unsigned int m_uSize;
};
