#pragma once

#include "volumeshop.h"

#include "BasicPlugin.h"
#include "Exporter.h"

#define DECLARE_EXPORTERPLUGIN(name) DECLARE_PLUGIN(Exporter,name)
#define DEFINE_EXPORTERPLUGIN(name,description,icon) DEFINE_PLUGIN(Exporter,name,description,icon)

class ExporterPlugin : public BasicPlugin<Exporter>
{
public:
	ExporterPlugin(Environment & envEnvironment, const std::string & strFilename) : BasicPlugin<Exporter>(envEnvironment,strFilename)
	{
	};

	virtual ~ExporterPlugin()
	{
	}

	virtual const bool IsAccepted(const std::string & strFilename)
	{
		if (GetInstance())
			return GetInstance()->IsAccepted(strFilename);

		return false;
	};

	virtual void save(const std::string & strFilename)
	{
		if (GetInstance())
			GetInstance()->save(strFilename);
	};

	virtual const float GetProgress()
	{
		if (GetInstance())
			return GetInstance()->GetProgress();

		return 0.0f;
	};

};
