#pragma once

#include "volumeshop.h"

class Exception
{
public:

	Exception()
	{
	};

	Exception(const std::string & strMessage) : m_strMessage(strMessage)
	{
	};

	Exception(const char * pFormat, ...)
	{
		if (pFormat == NULL)
			return;

		char vcText[1024];
		va_list ap;

		va_start(ap, pFormat);
		vsprintf(vcText, pFormat, ap);
		va_end(ap);

		m_strMessage = std::string(vcText);
	};

	~Exception()
	{
	};

	const std::string & GetMessage() const
	{
		return m_strMessage;
	};

private:

	std::string m_strMessage;
};

inline std::ostream & operator << (std::ostream & os, const Exception & excException)
{
	os << excException.GetMessage();
	return os;
}