#pragma once

#include "volumeshop.h"

#include "Vector.h"

class Event 
{
public:

	Event()
	{
	};

	~Event()
	{
	};

private:

};

class MouseEvent : public Event
{
public:

	enum Button
	{
		BUTTON_NONE = -1,
		BUTTON_LEFT	=  0,
		BUTTON_MIDDLE	=  1,
		BUTTON_RIGHT =  2
	};

	enum State
	{
		STATE_NONE = -1,
		STATE_UP =	 0,
		STATE_DOWN	=  1
	};

	enum Modifier
	{
		MODIFIER_SHIFT =  0x00200000,
		MODIFIER_CTRL	=  0x00400000,
		MODIFIER_ALT	=  0x00800000
	};

	MouseEvent(const Vector & vecPosition, const int iButton, const int iStateLeft, const int iStateMiddle, const int iStateRight, const int iModifiers) : m_vecPosition(vecPosition), m_iButton(iButton), m_iModifiers(iModifiers)
	{
		m_viState[BUTTON_LEFT] = iStateLeft;
		m_viState[BUTTON_MIDDLE] = iStateMiddle;
		m_viState[BUTTON_RIGHT] = iStateRight;
	};

	~MouseEvent()
	{
	};

	const Vector & GetPosition() const
	{
		return m_vecPosition;
	};

	const int GetButton() const
	{
		return m_iButton;
	};

	const int GetState() const
	{
		return m_viState[m_iButton];
	};

	const int GetLeftState() const
	{
		return m_viState[BUTTON_LEFT];
	};

	const int GetMiddleState() const
	{
		return m_viState[BUTTON_MIDDLE];
	};

	const int GetRightState() const
	{
		return m_viState[BUTTON_RIGHT];
	};

	const int GetModifiers() const
	{
		return m_iModifiers;
	};

private:

	Vector m_vecPosition;
	int m_iModifiers;
	int m_iButton;
	int m_viState[3];
};

class KeyboardEvent : public Event
{
public:

	enum Key
	{
		// misc keys
		KEY_ESCAPE = 0x1000,
		KEY_TAB = 0x1001,
		KEY_BACKTAB = 0x1002,
		KEY_BACKSPACE = 0x1003,
		KEY_RETURN = 0x1004,
		KEY_ENTER = 0x1005,
		KEY_INSERT = 0x1006,
		KEY_DELETE = 0x1007,
		KEY_PAUSE = 0x1008,
		KEY_PRINT = 0x1009,
		KEY_SYSREQ = 0x100A,

		// cursor movement
		KEY_HOME = 0x1010,
		KEY_END = 0x1011,
		KEY_LEFT = 0x1012,
		KEY_UP = 0x1013,
		KEY_RIGHT = 0x1014,
		KEY_DOWN = 0x1015,
		KEY_PRIOR = 0x1016, KEY_PAGEUP = KEY_PRIOR,
		KEY_NEXT = 0x1017, KEY_PAGEDOWN = KEY_NEXT,

		// modifiers
		KEY_SHIFT = 0x1020,
		KEY_CONTROL = 0x1021,
		KEY_META = 0x1022,
		KEY_ALT = 0x1023,
		KEY_CAPSLOCK = 0x1024,
		KEY_NUMLOCK = 0x1025,
		KEY_SCROLLLOCK = 0x1026,

		// function keys
		KEY_F1 = 0x1030,
		KEY_F2 = 0x1031,
		KEY_F3 = 0x1032,
		KEY_F4 = 0x1033,
		KEY_F5 = 0x1034,
		KEY_F6 = 0x1035,
		KEY_F7 = 0x1036,
		KEY_F8 = 0x1037,
		KEY_F9 = 0x1038,
		KEY_F10 = 0x1039,
		KEY_F11 = 0x103A,
		KEY_F12 = 0x103B,
		KEY_F13 = 0x103C,
		KEY_F14 = 0x103D,
		KEY_F15 = 0x103E,
		KEY_F16 = 0x103F,
		KEY_F17 = 0x1040,
		KEY_F18 = 0x1041,
		KEY_F19 = 0x1042,
		KEY_F20 = 0x1043,
		KEY_F21 = 0x1044,
		KEY_F22 = 0x1045,
		KEY_F23 = 0x1046,
		KEY_F24 = 0x1047,

		// F25 .. F35 only on X11
		KEY_F25 = 0x1048,
		KEY_F26 = 0x1049,
		KEY_F27 = 0x104A,
		KEY_F28 = 0x104B,
		KEY_F29 = 0x104C,
		KEY_F30 = 0x104D,
		KEY_F31 = 0x104E,
		KEY_F32 = 0x104F,
		KEY_F33 = 0x1050,
		KEY_F34 = 0x1051,
		KEY_F35 = 0x1052,

		// extra keys
		KEY_SUPER_L = 0x1053,
		KEY_SUPER_R = 0x1054,
		KEY_MENU = 0x1055,
		KEY_HYPER_L = 0x1056,
		KEY_HYPER_R = 0x1057,
		KEY_HELP = 0x1058,

		// 7 bit printable ASCII
		KEY_SPACE = 0x20,
		KEY_ANY = KEY_SPACE,
		KEY_EXCLAM = 0x21,
		KEY_QUOTEDBL = 0x22,
		KEY_NUMBERSIGN = 0x23,
		KEY_DOLLAR = 0x24,
		KEY_PERCENT = 0x25,
		KEY_AMPERSAND = 0x26,
		KEY_APOSTROPHE = 0x27,
		KEY_PARENLEFT = 0x28,
		KEY_PARENRIGHT = 0x29,
		KEY_ASTERISK = 0x2A,
		KEY_PLUS = 0x2B,
		KEY_COMMA = 0x2C,
		KEY_MINUS = 0x2D,
		KEY_PERIOD = 0x2E,
		KEY_SLASH = 0x2F,
		KEY_0 = 0x30,
		KEY_1 = 0x31,
		KEY_2 = 0x32,
		KEY_3 = 0x33,
		KEY_4 = 0x34,
		KEY_5 = 0x35,
		KEY_6 = 0x36,
		KEY_7 = 0x37,
		KEY_8 = 0x38,
		KEY_9 = 0x39,
		KEY_COLON = 0x3A,
		KEY_SEMICOLON = 0x3B,
		KEY_LESS = 0x3C,
		KEY_EQUAL = 0x3D,
		KEY_GREATER = 0x3E,
		KEY_QUESTION = 0x3F,
		KEY_AT = 0x40,
		KEY_A = 0x41,
		KEY_B = 0x42,
		KEY_C = 0x43,
		KEY_D = 0x44,
		KEY_E = 0x45,
		KEY_F = 0x46,
		KEY_G = 0x47,
		KEY_H = 0x48,
		KEY_I = 0x49,
		KEY_J = 0x4A,
		KEY_K = 0x4B,
		KEY_L = 0x4C,
		KEY_M = 0x4D,
		KEY_N = 0x4E,
		KEY_O = 0x4F,
		KEY_P = 0x50,
		KEY_Q = 0x51,
		KEY_R = 0x52,
		KEY_S = 0x53,
		KEY_T = 0x54,
		KEY_U = 0x55,
		KEY_V = 0x56,
		KEY_W = 0x57,
		KEY_X = 0x58,
		KEY_Y = 0x59,
		KEY_Z = 0x5A,
		KEY_BRACKETLEFT = 0x5B,
		KEY_BACKSLASH = 0x5C,
		KEY_BRACKETRIGHT = 0x5D,
		KEY_ASCIICIRCUM = 0x5E,
		KEY_UNDERSCORE = 0x5F,
		KEY_QUOTELEFT = 0x60,
		KEY_BRACELEFT = 0x7B,
		KEY_BAR = 0x7C,
		KEY_BRACERIGHT = 0x7D,
		KEY_ASCIITILDE = 0x7E
	};

	enum Modifier
	{
		MODIFIER_SHIFT =  0x00200000,
		MODIFIER_CTRL	=  0x00400000,
		MODIFIER_ALT	=  0x00800000
	};

public:

	KeyboardEvent(const int iKey, const int iModifiers) : m_iKey(iKey), m_iModifiers(iModifiers)
	{
	};

	~KeyboardEvent()
	{
	};

	const int GetKey() const
	{
		return m_iKey;
	};

	const int GetModifiers() const
	{
		return m_iModifiers;
	};

private:

	int m_iKey;
	int m_iModifiers;
};