#include "Environment.h"
#include "Viewer.h"
#include "ExporterPlugin.h"
#include "ImporterPlugin.h"

Environment::Environment() : m_uActiveData(0), m_uActiveSelection(0)
{
	m_eQuality = QUALITY_HIGH;
	m_vecDataVolumes.push_back(Volume<DataVoxel>());
	m_vecDataLabels.push_back(std::string("Data")+toString(m_uActiveSelection));
	m_vecDataUserTransformations.push_back(Matrix());

	m_vecSelectionVolumes.push_back(Volume<SelectionVoxel>());
	m_vecSelectionLabels.push_back(std::string("Selection")+toString(m_uActiveSelection));
	m_vecSelectionUserTransformations.push_back(Matrix());

	m_bGhostCutoutEnabled = false;
	m_bSelectionCutoutEnabled = false;

	m_fGhostGhosting = 0.0f;
	m_fSelectionGhosting = 0.0f;

	m_bSelectionPinEnabled = false;
	m_vecSelectionPinPosition = Vector(0.0f,0.0f,0.0f);
}

Environment::~Environment()
{
	std::multiset<Viewer*>::iterator j = m_mulViewers.end();

	for (std::multiset<Viewer*>::iterator i = m_mulViewers.begin(); i!= m_mulViewers.end(); i++)
	{
		if (i != j)
			(*i)->remove(this);

		j = i;
	}
}

void Environment::add(Viewer *pViewer)
{
	m_mulViewers.insert(pViewer);
}

void Environment::remove(Viewer *pViewer)
{
	std::multiset<Viewer*>::iterator i = m_mulViewers.find(pViewer);

	if (i != m_mulViewers.end())
		m_mulViewers.erase(i);
}

void Environment::update()
{
	std::multiset<Viewer*>::iterator j = m_mulViewers.end();

	for (std::multiset<Viewer*>::iterator i = m_mulViewers.begin(); i!= m_mulViewers.end(); i++)
	{
		if (i != j)
			(*i)->update();

		j = i;
	}
}