/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the Qt 3 compatibility classes of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef Q3SQLFORM_H
#define Q3SQLFORM_H

#include "QtCore/qobject.h"
#include "QtCore/qmap.h"

#ifndef QT_NO_SQL_FORM

class QSqlField;
class QSqlRecord;
class Q3SqlEditorFactory;
class Q3SqlPropertyMap;
class QWidget;
class Q3SqlFormPrivate;

class Q_COMPAT_EXPORT Q3SqlForm : public QObject
{
    Q_OBJECT
public:
    Q3SqlForm(QObject * parent = 0);
    ~Q3SqlForm();

    virtual void insert(QWidget * widget, const QString& field);
    virtual void remove(const QString& field);
    int         count() const;

    QWidget *   widget(int i) const;
    QSqlField * widgetToField(QWidget * widget) const;
    QWidget *   fieldToWidget(QSqlField * field) const;

    void        installPropertyMap(Q3SqlPropertyMap * map);

    virtual void setRecord(QSqlRecord* buf);

public slots:
    virtual void readField(QWidget * widget);
    virtual void writeField(QWidget * widget);
    virtual void readFields();
    virtual void writeFields();

    virtual void clear();
    virtual void clearValues();

protected:
    virtual void insert(QWidget * widget, QSqlField * field);
    virtual void remove(QWidget * widget);
    void clearMap();

private:
    Q_DISABLE_COPY(Q3SqlForm)

    virtual void sync();
    Q3SqlFormPrivate* d;
};

#endif // QT_NO_SQL

#endif // Q3SQLFORM_H
