/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the Qt 3 compatibility classes of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef Q3POINTARRAY_H
#define Q3POINTARRAY_H

#include "QtGui/qpolygon.h"

class Q_COMPAT_EXPORT Q3PointArray : public QPolygon
{
public:
    inline Q3PointArray() : QPolygon() {}
    inline Q3PointArray(const QRect &r, bool closed=false) : QPolygon(r, closed) {}
    inline Q3PointArray(const QPolygon& a) : QPolygon(a) {}

    inline Q3PointArray copy() const { return *this; }
    inline bool isNull() { return isEmpty(); }
    void makeEllipse(int x, int y, int w, int h);
#ifndef QT_NO_WMATRIX
    void makeArc(int x, int y, int w, int h, int a1, int a2);
    void makeArc(int x, int y, int w, int h, int a1, int a2, const QMatrix &matrix);
#endif
    Q3PointArray cubicBezier() const;
};

#endif // Q3POINTARRAY_H
