#include "init.h"

int  ms_leftb(void)
/*
ͻ
 berprft, ob linke Maustaste gedrckt wurde.                          
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          0 -> linke Maustaste nicht gedrckt              
                       1 -> linke Maustaste gedrckt                    
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{

	union REGS reg;

	reg.x.ax = 0x0003;
	int86(0x0033, &reg, &reg);
	return (reg.x.bx & 1);
}

int  ms_rightb(void)
/*
ͻ
 berprft, ob rechte Maustaste gedrckt wurde.                         
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          0 -> rechte Maustaste nicht gedrckt             
                       1 -> rechte Maustaste gedrckt                   
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{

	union REGS reg;

	reg.x.ax = 0x0003;
	int86(0x0033, &reg, &reg);
	return(reg.x.bx & 2);
}

void   ms_pos  ( int *x,
					 int *y )
/*
ͻ
 Liefert die aktuelle Mausposition in Pixel.                            
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     x (X-Koordinate des Mauszeigers)                 
                       y (Y-Koordinate des Mauszeigers)                 
 Returnwert:           keiner                                           
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x0003;
	int86 (0x0033, &reg, &reg);
	*x = reg.x.cx;
	*y = reg.x.dx;
}


void  ms_setXY(int x,
				  int y)
/*
ͻ
 Setzt den Mauszeiger an die angegebene Position.                       
͹
                                                                        
 Eingabeparameter:     x (horizontale Mausposition in Pixel)            
                       y (vertikale Mausposition in Pixel)              
 Ausgabeparameter:     keine                                            
 Returnwert:           keiner                                           
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x0004;
	reg.x.cx = x;
	reg.x.dx = y;
	int86(0x0033, &reg, &reg);
}

void  ms_off(void)
/*
ͻ
 Deaktiviert den aktuellen Maustreiber.                                 
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwert:           keiner                                           
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x001f;
	int86(0x0033, &reg, &reg);
}

int  ms_reset(int *anzbuttons)
/*
ͻ
 Initialisiert den Maustreiber und setzt den Mauszieger in die Mitte    
 des Bildschirms, ohne ihn dabei sichtbar zu machen.                    
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     anzbuttons (Anzahl der zur Verfgung stehenden   
                                   Mausbuttons)                         
 Returnwerte:          0 (kein Maustreiber installiert)                 
                       1 (Maustreiber vorhanden)                        
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x0000;
	int86(0x0033, &reg, &reg);
	if (reg.x.ax == 0xffff)
	{
		*anzbuttons = reg.x.bx;
		return(1);
	}
	else
		return(0);
}

void  ms_visible(void)
/*
ͻ
 Macht den Mauszeiger am Bildschirm sichtbar.                           
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwert:           keiner                                           
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x0001;
	int86(0x0033, &reg, &reg);
}

void  ms_hide(void)
/*
ͻ
 Macht den Mauszeiger am Bildschirm unsichtbar.                         
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwert:           keiner                                           
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	union REGS reg;

	reg.x.ax = 0x0002;
	int86(0x0033, &reg, &reg);
}

int  ms_range(pos)
struct box *pos;
/*
ͻ
 berprft, ob sich der Mauszeiger innerhalb eines angegebenen recht-   
 eckigen Bereiches befindet.                                            
͹
                                                                        
 Eingabeparameter:     pos (Zeiger auf rechteckigen Bereich)            
 Ausgabeparameter:     keine                                            
 Returnwerte:          TRUE (Mauszeiger innerhalb des Bereiches)        
                       FALSE (Mauszeiger nicht innerhalb des Bereiches) 
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	int x,y;

	ms_pos(&x, &y);
	if ((x>=pos->x1) && (x<=pos->x2) && (y>=pos->y1) && y<=pos->y2)
		return (TRUE);
	else
		return (FALSE);
}
