#include "init.h"

#define SIN 1
#define COS 2
#define TAN 3
#define COT 4
#define LN  5
#define EXP 6
#define POW 7
#define SUB 8  /* einstellige Funktion - */
#define ADD 9  /* einstellige Funktion + */
#define LOG 10


/*
ͻ
 Routinen und Variablen zur ESA-internen Speicherverwaltung             
͹
 Funktionen:                                                            
                                                                        
 struct node *Malloc(bytes)  : Speicher reservieren.                    
 void InitMemory(void)       : Kompletten Speicher freigeben und        
                               neu initialisiernen.                     
͹
 Globale Variablen:                                                     
                                                                        
 struct node  Memory[MAX_NODES]: Der zu vergebende Speicher             
 struct node *MemoryPointer:  Zeiger auf nchstes freie Node in Memory  
ͼ
*/

struct node  *Malloc(void)
{
	MemoryPointer++;
	return(MemoryPointer);
}

void  InitMemory(void)
{
int i;

	for(i=0; i<MAX_NODES; i++) {
				Memory[i].info  = 0;
				Memory[i].left  = NULL;
				Memory[i].right = NULL;
	}
	MemoryPointer = Memory;
}

int ch;


// Initialisieren der Variablen/Konstanten/Zahlen Struktur.

void  InitList()
{
		int i;
	 for(i=0;i<126; i++) var_const_list[i].exist = 0;
}

// Zahl in Variablen/Konstanten/Zahlen Struktur eintragen.

int  InsertNumber(f)
double f;
{
	 int i=26;

	 while(var_const_list[i].exist && i<126) i++;
	 if (i==126) return(0);                         /* Nix mehr frei */
	 var_const_list[i].exist=1;
	 var_const_list[i].fvalue=f;
	 return(i+97);
}

// Prfen, ob var eine gerade verwendete Variable ist

int  is_var(char var)
{
	int i,ret=0;

	for (i=0;i<anzKoor;i++)
		if (Koordinaten[i].var == var) ret=1;
	return(ret);
}

// Feststellen welchen Koordinate die Variable var belegt.

int  GetIndex(var)
char var;
{
	int i, ret=-1;
	for (i=0;i<anzKoor;i++)	if (Koordinaten[i].var == var) ret=i;
	return(ret);
}

// Zhle die vorhandenen Konstanten. Anmerkung: In der Var/Konst/Zahlen
// Struktur sind Variablen und Konstanten im Indexbereich von 0 bis 25
// abgespeichert.

int  GetCL(konst)
char *konst;
{
	 int i, anz;

	 anz = 0;
	 for(i=0;i<26;i++) {
			if ((var_const_list[i].exist) && (!is_var(i+97)))
			{
				konst[anz]=i+97;
				anz=anz+1;
			} /* if */
	 } /* for */
	 return(anz);
}

// Feststellen, wie viele Zeichen lang die Zahl in im String Formel ist.
// Lnge zurckgeben.

int  Increment(formel)
char *formel;
{
	 int c=0, pm=0;

	 while(isdigit(formel[ch+c])) c++;
	 if (formel[ch+c]=='.') c++;
	 while(isdigit(formel[ch+c])) c++;

	 if (formel[ch+c]=='e' || formel[ch+c]=='E') {
		  c++;
		  if (formel[ch+c]=='+' || formel[ch+c]=='-') { c++;pm=1;}
		  if (!isdigit(formel[ch+c]))  c=c-1-pm;
		  else while(isdigit(formel[ch+c])) c++;
		  }
	 return(c);
}

// Alle Leerzeichen aus STRING entfernen.

void  KillSpaces(string)
char *string;
{
	 int v=0,n=0;

	 while(string[v]  && v<FORMELLEN) {
		if(string[v]!=' ') string[n++]=string[v];
		v++;
	 }
	 for(;n<FORMELLEN; string[n++]=NULL);  /* Rest mit NULLen fllen */
}

// Variable/Konstante umwandeln und in
// Variablen/Konstanten/Zahlen-Struktur eintragen.

struct node  *VarConst(formel)
char *formel;
{
	 struct node *ptr;

	 if(formel[ch]<97||formel[ch]>122)  return(NULL); /* Kleinbuchstabe? */
	 if(islower(formel[ch+1])||formel[ch+1]=='(') return(NULL);

	 var_const_list[formel[ch]-97].exist = 1;
	 if(!(ptr = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); };
	 ptr->info = formel[ch++];
	 ptr->left = NULL;
	 ptr->right = NULL;
	 return(ptr);
}

// Funktionsnamen feststellen. Rckgabe des entsprechenden Zahlencodes.

int  Functionname(formel,len)
char *formel;
int *len;
{
	 if (!(strncmp(&formel[ch],"sin",3)))  { *len=3; return(SIN); }
	 if (!(strncmp(&formel[ch],"cos",3)))  { *len=3; return(COS); }
	 if (!(strncmp(&formel[ch],"tan",3)))  { *len=3; return(TAN); }
	 if (!(strncmp(&formel[ch],"cot",3)))  { *len=3; return(COT); }
	 if (!(strncmp(&formel[ch],"ln",2)))   { *len=2; return(LN);  }
	 if (!(strncmp(&formel[ch],"exp",3)))  { *len=3; return(EXP); }
	 if (!(strncmp(&formel[ch],"pow",3)))  { *len=3; return(POW); }
	 if (!(strncmp(&formel[ch],"log",3)))  { *len=3; return(LOG); }
	 return(0);
}

// Umwandlung einer Funktion (ein und zweistellig)

struct node  *Function(formel)
char *formel;
{
	 struct node *ptr, *left, *right;
	 int f=0, len;

	 left = right = NULL;
	 if (!(f=Functionname(formel,&len))) return(NULL); /* Funktion?       */
	 ch+=len;
	 if(formel[ch]!='(')  return(NULL);                /* linke Klammer?  */
	 ch++;
	 if(!(left = Ausdruck(formel))) return(NULL);      /* Ausdruck?       */
	 if(f==POW) {
		  if(formel[ch]!=',') return(NULL); 				/* Beistrich?      */
		  ch++;
		  if(!(right = Ausdruck(formel)))               /* 2.Ausdruck?     */
					 return(NULL);
	 }
	 if(formel[ch]!=')') return(NULL);                 /* rechte Klammer? */
	 ch++;
	 if(!(ptr = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); };
	 ptr->info = f;
	 ptr->left = left;
	 if(f==POW) ptr->right = right;
	 else ptr->right = NULL;
	 return(ptr);
}

// Umwandlung einer Zahl.

struct node  *Number(formel)
char *formel;
{
	 struct node *ptr;
	 double f;
	 int n;

	 sscanf(&formel[ch],"%lf",&f);
	 n=Increment(formel);
	 if(n==0) return(NULL);             /* ERROR Behandlung */
	 ch=ch+n;
	 if(!(ptr = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); }
	 ptr->info = InsertNumber(f);       /* Zahl in Liste eintragen */
	 ptr->left = NULL;
	 ptr->right = NULL;
	 return(ptr);
}

// Umwandlung eines Faktors

struct node  *Faktor(formel)
char *formel;
{
	 struct node *ptr, *left;

	 switch(formel[ch]) {
		  case '(': ch++;                                       /* (        */
						if(!(ptr = Ausdruck(formel))) return(NULL); /* Ausdruck */
						if(formel[ch]!=')') return(NULL);           /* )        */
						ch++;
						break;
		  case '-':
		  case '+': ch++;                                       /* +,-      */
						if(!(left = Term1(formel))) return(NULL);   /* Term1    */
						if(!(ptr = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); }
						if(formel[ch]=='+') ptr->info = ADD;
						else                ptr->info = SUB;
						ptr->right = NULL;
						ptr->left  = left;
						break;
		 default:   if(!(ptr = Number(formel)))                 /* Number?   */
						  if (!(ptr = VarConst(formel)))            /* VarConst? */
							 if (!(ptr = Function(formel)))          /* Function? */
								return(NULL);
						break;
	 }
	 return(ptr);
}

// Umwandlung einer Terms 2.Art (Potenzieren)

struct node  *Term2(formel)
char *formel;
{
	 struct node *ptr,*ptr1;

	 if(!(ptr = Faktor(formel))) return(NULL);      /* Faktor */
	 while(formel[ch]=='^') {                       /* ^      */
		  if(!(ptr1 = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); }
		  ptr1->info = formel[ch++];
		  ptr1->left = ptr;
		  if(!(ptr1->right = Faktor(formel)))        /* Faktor */
				return(NULL);
		  ptr = ptr1;
	 }
	 return(ptr);
}

// Umwandlung eines Terms 1.Art (Division, Multiplikation)

struct node  *Term1(formel)
char *formel;
{
	 struct node *ptr,*ptr1;

	 if(!(ptr = Term2(formel))) return(NULL);       /* Term2 */
	 while(formel[ch]=='*' || formel[ch]=='/') {    /* *,/   */
		  if(!(ptr1 = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); }
		  ptr1->info = formel[ch++];
		  ptr1->left = ptr;
		  if(!(ptr1->right = Term2(formel)))         /* Term2 */
				return(NULL);
		  ptr = ptr1;
	 }
	 return(ptr);
}


// Umwandlung eines "Ausdrucks" (Addition und Subtraktion)

struct node  *Ausdruck(formel)
char *formel;
{
	 struct node *ptr,*ptr1;

	 if(!(ptr = Term1(formel))) return(NULL);       /* Term1 */
	 while(formel[ch]=='+' || formel[ch]=='-') {    /* +,-   */
		  if(!(ptr1 = Malloc())) { PrintStatus("Speicher-malloc"); return(NULL); }
		  ptr1->info = formel[ch++];
		  ptr1->left = ptr;
		  if(!(ptr1->right = Term1(formel)))          /* Term1 */
				return(NULL);
		  ptr = ptr1;
	 }
	 return(ptr);
}

// Umwandlung einer Formel von der Stringdarstellung in die Treedarstellung

struct node  *MakeTree(formel)
char *formel;
{
	 struct node *tree;

	 KillSpaces(formel); /* Spaces aus Formel entfernen   */
	 ch=0;               /* Formelzeiger initialisienen   */

	 if(!(tree = VarConst(formel))) return(NULL);    /* VarConst       */

	 if(formel[ch]=='\'') ch++;                      /*  '  (optional) */
	 if(formel[ch]=='=') {                           /*  =             */
		  ch++;
		  if(!(tree = Ausdruck(formel))) return(NULL);/* Ausdruck       */
		  if(formel[ch]!=0) return(NULL);             /* Stringende     */

	 }
	 else  return(NULL);
	 return(tree);
}

// Fehlerbehandlungsroutine. Wird vom System beim Auftreten des SIGFPE
// Signal aufgerufen.

void FloatingError(sig, sig1)
int sig, sig1;
{       /* sig1 enthlt einen in FLOAT.H beschriebenen Wert  und
		gibt die Art des Prozessorfehlers an. */

	int sig2 = sig; /* Warning bei Compilation verhindern... */
	sig2 = sig1;    /* Warning bei Compilation verhindern... */
	sig2 = sig2;    /* Warning bei Compilation verhindern... */
	/* Tue nichts, wenn der Fehler frher schon mal aufgetreten ist */
	if(!error_code) {
		PrintStatus("!!! FLOATING POINT ERROR !!!");
		error_code=1;
	}

	/* Koprozessor wieder zurcksetzen !!!!! */
	_fpreset();
	/* Floating exception wieder setzen - wird beim Eintreten immer
		wieder auf Defaultroutine zurckgesetzt !!  */
	signal(SIGFPE, FloatingError);
}



// Fehlerbehandlungsroutine. Wird vom System bei Bedarf aufgerufen.

int matherr(e)
struct exception *e;
{
	strcpy(ErrorMessage, " ** Funktion: ");
	strcat(ErrorMessage, e->name);
	switch(e->type) {
		 case DOMAIN:   strcat(ErrorMessage, " ** Type: DOMAIN");
							 e->retval = 0.0;
							 break;
		 case OVERFLOW: strcat(ErrorMessage, " ** Type: OVERFLOW");
							 e->retval = 1.0;
							 break;
		 case SING:     strcat(ErrorMessage, " ** Type: SINGULARITY");
							 break;
		 case TLOSS:    strcat(ErrorMessage, " ** Type: LOSS OF SIGNIFIKATION");
							 break;
		 case UNDERFLOW:strcat(ErrorMessage, " ** Type: UNDERFLOW");
							 break;
		 default:       strcat(ErrorMessage, " **  Type: UNKNOWN !!");
							 break;
	}
	error_code=1;
	/* Koprozessor arbeite wieder */
	_fpreset();
	return(1);
}


// Auswertung eines Formel-Trees. Rekursive Abarbeitung des Baumes.

double  Eval(tree)
struct node *tree;
{
	if (!tree || error_code) return(0.0);

	switch(tree->info) {
				case '+': return(Eval(tree->left)+Eval(tree->right));
				case ADD: return(Eval(tree->left));
				case '-': return(Eval(tree->left)-Eval(tree->right));
				case SUB: return(-Eval(tree->left));
				case '*': return(Eval(tree->left)*Eval(tree->right));
				case '/': return(Eval(tree->left)/Eval(tree->right));
				case '^':
				case POW: return(pow(Eval(tree->left),Eval(tree->right)));
				case SIN: return(sin(Eval(tree->left)));
				case COS: return(cos(Eval(tree->left)));
				case TAN: return(tan(Eval(tree->left)));
				case COT: return(1/tan(Eval(tree->left)));
				case LN : return(log(Eval(tree->left)));
				case LOG: return(log10(Eval(tree->left)));
				case EXP: return(exp(Eval(tree->left)));
				default : return(var_const_list[tree->info-97].fvalue);
	 }
}
