/** \file XmlTools.cpp
 * \brief The implementation of the 'XmlTools' functions.
 */

#include "XmlTools.h"

#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMDocumentType.hpp>
#include <xercesc/dom/DOMElement.hpp>
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>
#include <xercesc/dom/DOMNodeIterator.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/dom/DOMText.hpp>
XERCES_CPP_NAMESPACE_USE

namespace OSkA
{
	float* getXYZAttributes(DOMNode* node)
	{
		float* ret=new float[3];

		ret[0]=getFloatAttribute(node, "x");
		ret[1]=getFloatAttribute(node, "y");
		ret[2]=getFloatAttribute(node, "z");

		return ret;
	}

	char* getCharAttribute(DOMNode* node, char* attributeName)
	{
		DOMElement* currentNode=dynamic_cast< xercesc::DOMElement* >(node);

		XMLCh* an=XMLString::transcode(attributeName);
		char* ret=XMLString::transcode(currentNode->getAttribute(an));
		XMLString::release(&an);

		return ret;
	}

	float getFloatAttribute(DOMNode* node, char* attributeName)
	{
		char* c=getCharAttribute(node, attributeName);
		float ret=atof(c);
		XMLString::release(&c);
		return ret;
	}

	int getIntAttribute(DOMNode* node, char* attributeName)
	{
		char* c=getCharAttribute(node, attributeName);
		int ret=atoi(c);
		XMLString::release(&c);
		return ret;
	}

	DOMNodeList* getNodeList(DOMDocument* node, char* nodeName)
	{
		XMLCh* c=XMLString::transcode(nodeName);
		DOMNodeList* ret=node->getElementsByTagName(c);
		XMLString::release(&c);
		return ret;
	}

	DOMNodeList* getNodeList(DOMElement* node, char* nodeName)
	{
		XMLCh* c=XMLString::transcode(nodeName);
		DOMNodeList* ret=node->getElementsByTagName(c);
		XMLString::release(&c);
		return ret;
	}
}