/** \file Keyframe.cpp
 * \brief The implementation of the 'Keyframe' class.
 */

#include "Keyframe.h"

namespace OSkA
{
	Keyframe::Keyframe()
	{
		setTime(0);
		setTransform(new Matrix());
	}

	Keyframe::~Keyframe()
	{
		delete transform;
	}

	Keyframe::Keyframe(float time, Matrix* transform)
	{
		setTime(time);
		setTransform(transform);
	}

	void Keyframe::setTime(float time)
	{
		this->time=time;
	}

	void Keyframe::setTransform(Matrix* transform)
	{
		this->transform=transform;
	}

	float Keyframe::getTime()
	{
		return time;
	}

	Matrix* Keyframe::getTransform()
	{
		return transform;
	}
}
